#
# -*- coding: utf-8 -*-
#-----------------------------------------
#pythonバージョン、外部パッケージのチェック
#-----------------------------------------
# python 3 以上（推奨3.3以上）
# canvasvg パッケージ
# zenhan モジュール
# Inkscapeアプリケーション（python3.3以上で存在確認する）
# xte コマンド（Linux環境＋python3.3以上で存在確認する）
# poster コマンド（Linux環境＋python3.3以上で存在確認する）
# ---------------------------------------------------
# Inkscape経由でPDF出力できる
# ubuntu(linux)環境ではxteを利用して強引にIME制御をしている。
# ubuntu(Linux)環境ではInkscape+poster経由で
#    分割印刷用psを出力又は印刷（lpr経由）できる。
# ---------------------------------------------------
import sys
import platform
import pkg_resources
import pkgutil

main = False

def start_check():
  result = {'ver3':None, 'ver3.3':None, 'vertpl':'', 'os':'',
            'canvasvg':None, 'zenhan':None, 'inkscape':None,
            'xte':None, 'poster':None, 'lpr':None, 'run':None}
  #OS
  result['os'] = platform.system()
  #python version
  result['vertpl'] = vtpl = platform.python_version_tuple()
  if main:
    sys.stdout.write('Pythonバージョン--->'+'.'.join(vtpl)+'\n')
  #python2
  if not int(vtpl[0])>=3:
    result['ver3'] = False
    sys.stdout.write("--- python3の環境が必要です。---\n")
    return result
  result['ver3'] = True
  #python3.3
  if (int(vtpl[0])==3 and int(vtpl[1])>=3) or int(vtpl[0])>=4:
    result['ver3.3'] = True
    import shutil
    #inkscape ??Windowsでもコマンド名'inkscape'??
    result['inkscape'] = True if shutil.which('inkscape') else False
    if result['os'] == 'Linux':
      #xte
      result['xte'] = True if shutil.which('xte') else False
      #poster
      result['poster'] = True if shutil.which('poster') else False
      #lpr
      result['lpr'] = True if shutil.which('lpr') else False
  else:
    result['ver3.3'] = False
  
  #インストール済みパッケージリスト
  wkset = pkg_resources.working_set
  #pkgnamelistで必要なパッケージ名を確認
  pkgnamelist=[i.project_name for i in wkset]

  #インストール済みモジュール
  mdl = pkgutil.iter_modules()
  #mdlnamelistで必要なモジュール名を確認
  mdlnamelist = [i[1] for i in mdl]

  #標準ライブラリ以外のパッケージ、モジュール
  # canvasvg パッケージ
  # zenhan モジュール

  if not 'canvasvg' in pkgnamelist:
    result['canvasvg'] = False
    sys.stdout.write('×--- canvasvgパッケージをインストールしてください。---\n')
    sys.stdout.write('      ex.. ubuntuなら　sudo apt-get install canvasvg\n')
    sys.stdout.write('           windowsなら　pip install canvasvg\n')
    sys.stdout.write('      ※python2と3が共存しているなら python3-canvasvg\n')
    
  else:
    result['canvasvg'] = True
    if main:
      sys.stdout.write('○canvasvgパッケージ--->インストール済み\n')
  if not 'zenhan' in mdlnamelist:
    result['zenhan'] = False
    sys.stdout.write('×--- zenhanモジュールをインストールしてください。---\n')
    sys.stdout.write('      ex.. ubuntuなら  sudo apt-get install zenhan\n')
    sys.stdout.write('           windowsなら　pip install zenhan\n')
    sys.stdout.write('      ※python2と3が共存しているなら python3-zenhan\n')
  else:
    result['zenhan'] = True
    if main:
      sys.stdout.write('○zenhanモジュール--->インストール済み\n')
  if result['ver3'] and result['canvasvg'] and result['zenhan']:
    result['run'] = True
    if main:
      print('○：実行環境が整っています。')
  else:
    result['run'] = False
    sys.stdout.write('×：実行環境が整っていません。\n')

  return result

#単独実行
if __name__=='__main__':
  main = True
  print(start_check())
  
