#
# -*- coding: utf-8 -*-
#

#相続関係説明図作成スクリプト
#sozoku_svg.py

#実行環境チェック
import check_platform  #スクリプト実行環境チェック
chkres = check_platform.start_check()
##  chkres = {'ver3':<T,F,N>, 'ver3.3':<T,F,N>, 'vertpl':<vertuple>,
##            'os':'<name>',  'canvasvg':<T,F,N>, 'zenhan':<T,F,N>,
##            'inkscape':<T,F,N>, 'xte':<T,F,N>, 
##            'poster':<T,F,N>, 'lpr':<T,F,N>, 'run':<T,F,N>}
##  <T,F,N> = True or False or None
##  <name> = os_name 'Linux ,Windows,..'
##  <vertuple> = python version tuple like ('3','4','3')
if not chkres['run']:
  import sys
  sys.exit()

from tkinter import *   #tkinter 標準ライブラリ
from tkinter import simpledialog
from tkinter import messagebox
from tkinter import filedialog
from tkinter import colorchooser
from sys import *       #sys 標準ライブラリ
import os.path          #os.path 標準ライブラリ
import pickle as pi     #pickle 標準ライブラリ
from subprocess import Popen, PIPE  #subprocess 標準ライブラリ
#import platform         #platform 標準ライブラリ
from canvasvg import canvasvg as svg  #外部パッケージ
import re     #re 標準ライブラリ
import zenhan  #zenhan 外部モジュール
import datetime  #標準モジュール
import set_dispfont as sedf #表示用フォント設定

#グローバル変数
cursys = chkres['os']   #Linux,Windows,Darwin..
screenwidth = 0
screenheight = 0
minscrlrgnx = 1000
minscrlrgny = 1000
filepathname = ''  #保存先のファイルパス名
#Sozokuインスタンスリスト（ライン、メモ含む）[instance,canvas-id,absid]
sozokulist = []
xsize = 80   #矩形width=80
ysize = 150  #矩形height=150
xspace = 60  #左右間隔
yspace = 80  #上下間隔
ymargin = 50  #キャンバスの上の余白
xmargin = 50 #キャンバスの左余白
yttl = ysize+yspace
xttl = xsize+xspace
defmax = 2000
xmax = defmax  #キャンバスのスクロール範囲
ymax = defmax
#フォント（入力フォントも等倍フォントがベター？）
deffontname = 'IPA明朝'   #このスクリプトでの既定フォント
#この表示フォントは仮指定
dispfontname = deffontname
#entryfont,entryfontmini,tatefontの仮指定
entryfont = ('IPA明朝','12')
entryfontmini = ('IPA明朝','8')
tatefont = 'IPA明朝'
#Label用のフォント（フォントはシステムデフォルト）
labelfont = ('','12')
labelfontmini = ('','8')

#接続対象のライン又は矩形の別と絶対id及び座標
#[[0,id,座標], [1,id,座標] ] 0=ライン,1=矩形
line_target = []
#図形識別
LineOBJ = 0
KukeiOBJ = 1
#矩形基本背景色
kucolor='#E4E4E4'
#文字色
defcolor = 'black'
#linelist = []   #Setuzokuインスタンスリスト
norkon_ys = 60  #通常婚姻Y-shift
saikon_ys = 30  #再婚Y-shift
saikon_xs = 20  #再婚X-shift
yoshi_xs = 20  #養子、認知等X-shift
yoshi_ys = 20  #養子等Y-shift
#絶対id保守
absidnow = 1
#相続人のアトリビュート入力用のリスト
human = []
#フォントサイズ
size_na = 12
size_da = 10
size_ad = 8
size_me = 8  #メモ
#文字間隔（上下）
fntsp = 3
#DPI(dot_per_inch)標準
dpi = 96
#Point_per_inch（固定）１ポイントは1/72インチ
ppi = 72
#ダンプ一時保存用ファイル名
dmptempf = './_dmp_temp_f_'
#変更されたらTrue
modified = False
#コピー対象のインスタンス
cur_insta = 0
#貼り付け有効（コピー済み）
enable_paste = False
#コピーバッファ
copy_buf = ""
#メモWK
memowk = ""
#フォントサイズ等入力用リスト
sizelist = []
#ボックスの外枠線スタイル入力用リスト
outline_style_list = []
#ボックスのカラー入力用リスト
colorlist = []
#ボックススタイル一括設定戻り値（SozokuLooks_dialogの戻り値と同じ）
boxlookslist = []
#ラインスタイル編集用リスト
line_style_list = []
#スタイル変更対象カラー
now_style_color = 'lightblue'
#編集対象カラー
#now_edit_color = 'lightyellow'
now_edit_color = 'orange'
#貼り付けオプション
with_style=1
no_style=2
only_style=3
#斜線区分
no_diag = 0
l_diag = 1
r_diag = 2
both_diag = 3
#undoリスト
undolist = []
undo_flg = False
#初期設定
sozokudic = {}
dicfile = './sozoku_init.dic'
keyname = 'subfontname'
#キャンバス移動関係
scan_mark_flg = False
#１行１列挿入削除関連
rc_coord = 0
#Boxスタイルのデフォルト値
default_box_styles = []
#モード変更時のコールバック関数のid
mode_func_id = ''
#バックアップファイル関連
bkfmax = 10
bkf_over = False
bkfname = '_sozoku_unsaved_'  #ファイル名の後半
bkfdirname = 'sozoku_unsaved'     #ワークフォルダ内のサブ名
bkfdir = ''  #バックアップディレクトリのパス
#バージョン（表示フォント用のスクリプトも含めて）
version = 'sozoku_svg'+'  '+ '0.7.02.08'
#念のため全角で。表示段階で半角に変換
homepage = 'ｈｔｔｐ：／／ｗｗｗ．ｓｏｚｏｋｕ．ｉｎｂｌａｎｋ．ｎｅｔ'
mailaddr = 'ｒｅｎｒａｋｕ＠ｓｏｚｏｋｕ．ｉｎｂｌａｎｋ．ｎｅｔ'
#box連動メモ関連
boxmemo_flg = False
boxmemo_bind = ''
memopop_iboxmemo = 0
now_boxmemo_color = '#66cccc'
boxmemo_func = None

#---------------------------------------------------------
#　相続人クラス                               class Sozoku
##  相続関係人一人を表すクラス
##  Box内に続柄、氏名、生年月日、死亡年月日を表示し、
##  Box右外側に住所を表示。
##  引数：
##   zahyo=Boxの矩形座標(x0,y0,x1,y1)
##   paste=None コピー＆ペーストで貼り付ける場合の引数
##         with_style, no_style, only_style
##  ・表示はすべて縦書き。
##  ・氏名と住所は複数行の表示が可能。
##　・数字文字は半角組文字表示が基本。西暦年を始め３桁以上の数字文字がある場合
##　　上位桁から２桁毎に半角組文字表示となる。
##　・数字も１桁毎に縦並びにする場合、半角組文字をしない区間を’＃＃’で指定する。
#---------------------------------------------------------
class Sozoku:
  #zahyo=Boxの矩形座標(x0,y0,x1,y1)
  #paste=with_style,no_style,only_style
  def __init__(self,zahyo,paste=None):
    #相続の属性
    self.type = 'box'
    self.absid = 0    #絶対id
    self.kukei = zahyo  #矩形作成座標
    self.skukei = []    #参考矩形座標
    self.lineids = []   #接続したラインの絶対idリスト
    self.memoids = []   #連動メモの絶対idリスト
    #self.atrb = False   #名前など入力済み True　→動作に関係ないので削除
    self.edit_cancel = False
    self.zoku =""
    self.name = ""
    self.birth = ""
    self.die = ""
    self.addr = ""
    self.tate_zoku = ""
    self.tate_name = ""
    self.tate_birth = ""
    self.tate_die = ""
    self.tate_addr = ""
    #スタイルは既定値から読み込む
    #stylelist = box_init_style()
    stylelist = default_box_styles
    self.size_zoku,self.zoku_bold,self.zoku_italic = stylelist[0]
    self.size_name,self.name_bold,self.name_italic = stylelist[1]
    self.size_birth,self.birth_bold,self.birth_italic = stylelist[2]
    self.size_die,self.die_bold,self.die_italic = stylelist[3]
    self.size_addr,self.addr_bold,self.addr_italic = stylelist[4]
    #枠線パターン、幅初期値
    self.dashptn,self.outlinewidth = stylelist[5]
    #色初期値
    self.zoku_color,self.name_color,self.birth_color,self.die_color,\
                    self.addr_color,self.outline_color,self.bg_color = stylelist[6]
    #斜線初期値
    self.diagline,self.diagwidth,self.diagptrn,self.diagcolor = stylelist[7]
    #フォント指定文字列
    self.zokufont = ""
    self.namefont = ""
    self.birthfont = ""
    self.diefont = ""
    self.addrfont = ""

    #スタイル付き、スタイルなし貼り付けの場合
    if paste == with_style or paste == no_style:
      self.from_buf_without_style()
    #スタイル付き、スタイルのみの場合
    if paste == with_style or paste == only_style:
      self.from_buf_style()
    #テキストスタイル付きのフォント指定文字列作成
    self.set_font_size_style()

    #相続矩形作成
    self.mkkukei()

    #絶対id取得
    if not undo_flg:
      self.absid = getabsid()

    #斜線(貼り付けでBOXが作成される場合) 絶対id取得後に
    if paste == with_style or paste == only_style:
      self.show_diagline()
    #マウスイベントのバインド設定
    self.set_tag_bind()
    
    #氏名、生年月日等の入力
    #BOX作成時のsozoku_edit()呼び出しはundolistに登録しない。
    undata = self.sozoku_edit(paste)
    #変更
    set_modified()

  #Boxのコピーデータの貼り付けで既存Boxのデータ置き換え
  #opt = with_style, no_style, only_style
  def replace_paste(self,opt):
    #氏名等を置き換え
    if opt == with_style or opt == no_style:
      self.from_buf_without_style()
    #スタイルを置き換え
    if opt == with_style or opt == only_style:
      self.from_buf_style()
    #再表示
    self.show_chg_style()
    
  #copy_bufからスタイル以外をコピー
  def from_buf_without_style(self):
    self.zoku,self.name,self.birth,self.die,self.addr = copy_buf[0]
    self.tate_zoku,self.tate_name,self.tate_birth,self.tate_die,self.tate_addr = \
                                                        copy_buf[1]
  #copy_bufからスタイルをコピー
  def from_buf_style(self):
    self.size_zoku,self.zoku_bold,self.zoku_italic = copy_buf[2]
    self.size_name,self.name_bold,self.name_italic = copy_buf[3]
    self.size_birth,self.birth_bold,self.birth_italic = copy_buf[4]
    self.size_die,self.die_bold,self.die_italic = copy_buf[5]
    self.size_addr,self.addr_bold,self.addr_italic = copy_buf[6]
    self.dashptn,self.outlinewidth = copy_buf[7]
    self.zoku_color,self.name_color,self.birth_color,self.die_color,\
                    self.addr_color,self.outline_color,self.bg_color = copy_buf[8]
    self.diagline,self.diagwidth,self.diagptrn,self.diagcolor = copy_buf[9]
  
  #表示用フォントサイズ、スタイルの設定
  def set_font_size_style(self):
    self.zokufont = self.set_font_sub(self.size_zoku,
                                      self.zoku_bold,self.zoku_italic)
    self.namefont = self.set_font_sub(self.size_name,
                                      self.name_bold,self.name_italic)
    self.birthfont = self.set_font_sub(self.size_birth,
                                       self.birth_bold,self.birth_italic)
    self.diefont = self.set_font_sub(self.size_die,
                                     self.die_bold,self.die_italic)
    self.addrfont = self.set_font_sub(self.size_addr,
                                      self.addr_bold,self.addr_italic)

  #表示用フォント設定下請け
  def set_font_sub(self,size,bold,italic):
    dispfont = []
    dispfont.append(tatefont)
    dispfont.append(size)
    if bold:
      dispfont.append('bold')
    if italic:
      dispfont.append('italic')
    return tuple(dispfont)
    
  #相続アトリビュートの編集（氏名、住所、生年月日など）
  def sozoku_edit(self,paste=None):
    undodata = []
    #貼り付け処理でない場合
    if not paste:
      global human
      human = [self.zoku,self.name, self.birth, self.die, self.addr]
      soinsta = Sozoku_dialog(canvas,'相続人属性の編集')
      if len(soinsta.result) == 0:  #キャンセルした場合
        self.edit_cancel = True
        return []
      elif human != soinsta.result[0]:  #データ変更がある場合
        self.edit_cancel = False
        #undo準備
        undodata = ['CHG','BOX',pi.dumps(self,2)]
        #result=[[name,birth,die,addr],[nametate,birthtate,dietate,addrtate]]
        self.zoku,self.name,self.birth,self.die,self.addr = soinsta.result[0]
        self.tate_zoku,self.tate_name,self.tate_birth,self.tate_die,\
                                      self.tate_addr = soinsta.result[1]
    #表示
    self.show_sozoku()
    return undodata

  #saveデータをloadした後でキャンバスに再描画する
  def redraw(self):
    #BOX表示
    self.mkkukei()
    #sozokulistのキャンバスidを更新
    sozokulist[sozoku_idx(self.absid)][1] = self.kuid
    #相続アトリビュートを表示
    #if self.atrb == True:
    self.show_sozoku()
    self.show_diagline()
    #タグバインドの設定
    self.set_tag_bind()

  #バインド設定
  def set_tag_bind(self):
    #マウスイベント処理
    #標準モード：ボックス移動、削除モードで削除
    canvas.tag_bind(self.kuid,'<Button-1>',self.pressed)
    canvas.tag_bind(self.kuid,'<Button1-Motion>',self.dragging)
    canvas.tag_bind(self.kuid,'<ButtonRelease-1>',self.b1release)
    #標準モード：Boxmemo連動対象Box指定
    canvas.tag_bind(self.kuid,'<Button-1>',self.takeboxmemo,'+')
    #標準モード：ダブルクリックで氏名等修正
    canvas.tag_bind(self.kuid,'<Double-Button-1>',self.sozoku_doubleclick)
    canvas.tag_bind(str(self.absid)+'atrb',
                    '<Double-Button-1>',self.sozoku_doubleclick)
    #Line追加モード：1とkuidと座標を返す
    canvas.tag_bind(self.kuid,'<Button-1>',self.idcoords,'+')
    #ボックス右クリックでポップアップメニュー
    if cursys == 'Darwin':  #macOS
      canvas.tag_bind(self.kuid,'<ButtonRelease-2>',self.popup)
      canvas.tag_bind(str(self.absid)+'atrb',
                      '<ButtonRelease-2>',self.popup)
    else:
      canvas.tag_bind(self.kuid,'<ButtonRelease-3>',self.popup)
      canvas.tag_bind(str(self.absid)+'atrb',
                      '<ButtonRelease-3>',self.popup)

  #boxmemoの連動対象Boxに<button-1>で指定された
  def takeboxmemo(self,event):
    if mode.get() == 'Nor' and boxmemo_flg and cur_insta.type == 'memo':
      global undolist
      #memoidsのアトリビュートがあるか否か
      if hasattr(self,'memoids'):
        if not cur_insta.absid in self.memoids:
          self.memoids.append(cur_insta.absid)
      else:
        self.memoids = [cur_insta.absid]
      #memoのboxidを編集
      cur_insta.boxid = self.absid
      #memoにタグを追加
      canvas.addtag_withtag(str(self.absid)+'boxmemo',
                            str(cur_insta.absid)+'memo')
      #undo準備
      if not undo_flg:
        undolist.append(['BOXIN','MEMO',[cur_insta.absid,cur_insta.boxid]])
      #boxmemo作業の終了処理
      chgboxmemo()
      messagebox.showinfo('メモ','連動メモに変更しました。')
      set_modified()

  #Box上の右クリックでPopUpメニュー呼び出し
  def popup(self,event):
    #ライン追加モードで２番目のボックス指定を待っているときはpopupしない
    if mode.get() == 'Lin' and len(line_target)==1:
      return
    #boxmemo追加中の場合はポップアップしない
    if boxmemo_flg:
      return
    global cur_insta
    cur_insta = sozoku_insta(self.absid)
    #バッファが空のとき貼り付けメニューdisabled
    i = popup_menu.index('貼り付け')
    if enable_paste:
      popup_menu.entryconfig(i,state='normal')
    else:
      popup_menu.entryconfig(i,state='disabled')
    #標準モード以外では連動メモを非選択に
    i = popup_menu.index('連動メモ追加')
    if mode.get() == 'Nor':
      popup_menu.entryconfig(i,state='normal')
    else:
      popup_menu.entryconfig(i,state='disabled')
    popup_menu.tk_popup(event.x_root,event.y_root,0)

  #一括スタイル設定の際にCALLされる
  def set_style(self):
    #グローバル変数boxlookslistからスタイルを読み込んで
    self.get_result(boxlookslist)
    #表示用フォントサイズ、スタイル文字列設定
    self.set_font_size_style()
    #表示
    #if self.atrb:
    self.show_sozoku()
    canvas.itemconfigure(self.kuid,fill=self.bg_color,
                         dash=tuple(self.dashptn),
                         width=self.outlinewidth,
                         outline=self.outline_color)
    self.show_diagline()

  #SozokuLooks_dialogからの結果を各アトリビュートに保存
  def get_result(self,result):
    self.size_zoku,self.zoku_bold,self.zoku_italic,self.zoku_color = result[0]
    self.size_name,self.name_bold,self.name_italic,self.name_color = result[1]
    self.size_birth,self.birth_bold,self.birth_italic,self.birth_color = result[2]
    self.size_die,self.die_bold,self.die_italic,self.die_color = result[3]
    self.size_addr,self.addr_bold,self.addr_italic,self.addr_color = result[4]
    self.dashptn,self.outlinewidth,self.outline_color,self.bg_color = result[5]
    self.diagline,self.diagwidth,self.diagptrn,self.diagcolor = result[6]

  #フォントサイズ、スタイル、外枠線、背景をまとめて編集するダイアログを呼び出す
  def looks_conf(self):
    #対象BOXの色を変える（補色にすべきか:しかし、黒の補色は白になる）
    canvas.itemconfigure(self.kuid,fill=now_style_color)
    #外部変数に現在値をセット
    global sizelist
    sizelist = [[self.size_zoku,self.zoku_bold,self.zoku_italic],
                [self.size_name,self.name_bold,self.name_italic],
                [self.size_birth,self.birth_bold,self.birth_italic],
                [self.size_die,self.die_bold,self.die_italic],
                [self.size_addr,self.addr_bold,self.addr_italic] ]
    global outline_style_list
    outline_style_list = [self.dashptn,self.outlinewidth]
    global colorlist
    colorlist = [self.zoku_color,self.name_color,self.birth_color,
                 self.die_color,self.addr_color,self.outline_color,
                 self.bg_color]
    global diag_list
    diag_list = [self.diagline,self.diagwidth,self.diagptrn,self.diagcolor]
    #入力ダイアログ
    insta = SozokuLooks_dialog(canvas,'ボックス表示設定')
    #変更されたら反映
    if len(insta.result):
      undodata = None
      #undo準備
      if not undo_flg:
        #global undolist
        #undolist.append(['CHG','BOX',pi.dumps(self,2)])
        undodata = pi.dumps(self,2)
      #結果取得
      self.get_result(insta.result)
      #スタイル変更後の再表示
      self.show_chg_style()
      #変更
      set_modified()
      return undodata
    else:
      #変更ない場合はBOXの背景を戻す
      canvas.itemconfigure(self.kuid,fill=self.bg_color)
      return None

  #スタイルが変更されたときの再表示
  def show_chg_style(self):
    #表示用フォントサイズ、スタイル文字列設定
    #self.set_font_size_style()
    #表示
    #self.show_sozoku()
    self.show_chg_font()
    canvas.itemconfigure(self.kuid,fill=self.bg_color,
                         dash=tuple(self.dashptn),
                         width=self.outlinewidth,
                         outline=self.outline_color)
    self.show_diagline()

  #表示フォントが変更されたときの再表示
  def show_chg_font(self):
    #表示用フォント、スタイル等文字列設定
    self.set_font_size_style()
    #表示
    self.show_sozoku()

  #斜線描画
  def show_diagline(self):
    #一旦ボックス内の斜線を消去して描画
    canvas.delete(str(self.absid)+'diag')
    if self.diagline == no_diag:
      return
    diagco = canvas.coords(self.kuid)
    if self.diagline==both_diag:
        x0,y0,x1,y1 = diagco[0],diagco[3],diagco[2],diagco[1]
        self.show_diagline_sub(x0,y0,x1,y1)
        x0,y0,x1,y1 = diagco[0],diagco[1],diagco[2],diagco[3]
        self.show_diagline_sub(x0,y0,x1,y1)
    else:
      if self.diagline==l_diag:
        x0,y0,x1,y1 = diagco[0],diagco[3],diagco[2],diagco[1]
      elif self.diagline==r_diag:
        x0,y0,x1,y1 = diagco[0],diagco[1],diagco[2],diagco[3]
      self.show_diagline_sub(x0,y0,x1,y1)

  #斜線描画下請け
  def show_diagline_sub(self,x0,y0,x1,y1):
    canvas.create_line(x0,y0,x1,y1,width=self.diagwidth,
                       fill=self.diagcolor,dash=tuple(self.diagptrn),
                       tags=('sozoku','box','diag',str(self.absid)+'diag'))
  #相続人矩形（Box）作成
  def mkkukei(self):
    self.kuid = canvas.create_rectangle(*self.kukei,dash=tuple(self.dashptn),
                                        width = self.outlinewidth,
                                        outline = self.outline_color,
                                        fill=self.bg_color,
                                        tags=('sozoku','box'))

  #Line接続用リスト（外部変数）に自身のidや座標をセット
  def idcoords(self,event):
    if mode.get() != 'Lin':
      return
    line_target.append([KukeiOBJ,self.absid,self.kukei])
    #１つ目の矩形なら背景変更
    if len(line_target)==1:
      canvas.itemconfigure(self.kuid,fill=now_edit_color)
    #配列に２つ入ったらライン描画
    if len(line_target)==2:
      #同じ矩形が選択されていないか
      if line_target[0][1]==line_target[1][1]:
        line_target.remove(line_target[1])
      else:
        draw_line()

  #このBoxに接続しているLineのidを追加
  def addlineid(self,lid):
    self.lineids.append(lid)

  #self.lineidsから指定されたラインidを削除
  def dellineid(self,lid):
    self.lineids.remove(lid)

  #Box自体の削除処理
  def deleteme(self):
    #undo情報
    undodata = []
    #連動メモの削除 連動メモは複数ある場合あり
    #メモ削除後に戻ってくるundodataはpickleそのもので配列にはなっていない
    if hasattr(self,'memoids'):
      if len(self.memoids):
        mlist = []
        for mid in self.memoids:
          mlist.append(sozokulist[sozoku_idx(mid)][0])
        for minst in mlist:
          undodata.append(minst.deleteme())
    #ボックスを削除する前に接続ラインを削除する
    if len(self.lineids):
      instalist = []
      for lid in self.lineids:
        instalist.append(sozokulist[sozoku_idx(lid)][0])
      #ループを分けないと親子ラインを削除する際に
      #lineidsやsozokulist自体が書き換えられるから
      for ins in instalist:
        res = ins.delline_sub()
        #undo情報
        if not undo_flg:
          undodata.extend(res)
    if not undo_flg:
      #undo準備
      self.kukei = canvas.coords(self.kuid)
      undodata.append(pi.dumps(self,2))
    canvas.delete(self.kuid)
    #自身のインスタンスリスト要素を削除
    del sozokulist[sozoku_idx(self.absid)]
    #相続矩形などを削除
    #if self.atrb:
    canvas.delete(str(self.absid)+'atrb')
    canvas.delete(str(self.absid)+'diag')
    return undodata
  
  #Boxをクリックした時の処理（移動、削除）
  def pressed(self,event):
    self.kukei = canvas.coords(self.kuid)
    #標準モード：移動（準備）
    if mode.get() == 'Nor':
      #boxmemo連動対象Box指定中なら移動なし
      if boxmemo_flg:
        return
      #移動表示用参考ボックス作成
      self.skuid = canvas.create_rectangle(*self.kukei,outline='gray')
      self.skukei = canvas.coords(self.skuid)
      #最初のマウス座標
      self.x = canvas.canvasx(event.x)
      self.y = canvas.canvasy(event.y)
    #削除モード
    else:
      if mode.get() == 'Del':
        res = self.deleteme()
        if len(res):
          global undolist
          undolist.append(['DEL','BOX',res])
          #変更
          set_modified()

  #移動（Boxがクリックされた後のドラッグで移動）
  def dragging(self,event):
    self.evx = canvas.canvasx(event.x)
    self.evy = canvas.canvasy(event.y)
    #標準モード以外は無視
    if mode.get() != 'Nor':
      return
    self.xmov = (int((self.evx-xmargin)/xttl)*xttl+xmargin-self.kukei[0]
            if (self.evx-xmargin)%xttl <= xsize else 0)
    self.ymov = (int((self.evy-ymargin)/yttl)*yttl+ymargin-self.kukei[1]
            if (self.evy-ymargin)%yttl <= ysize else 0)
    if self.xmov or self.ymov:
      #移動先に他のオブジェクトがないか（box位置の2ドット内側を調査）
      mc = canvas.coords(self.kuid)
      mc[0],mc[1],mc[2],mc[3] = mc[0]+self.xmov+2,mc[1]+self.ymov+2,\
                                mc[2]+self.xmov-2,mc[3]+self.ymov-2
      if not len(canvas.find_overlapping(mc[0],mc[1],mc[2],mc[3])):
        #BOX移動
        canvas.move(self.kuid,self.xmov,self.ymov)
        #他のパーツも移動
        canvas.move(str(self.absid)+'atrb',self.xmov,self.ymov)
        canvas.move(str(self.absid)+'diag',self.xmov,self.ymov)
        #連動メモも移動
        canvas.move(str(self.absid)+'boxmemo',self.xmov,self.ymov)
        #Undo準備
        undodata = []
        undodata.append(['BOX',self.absid,[-self.xmov,-self.ymov]])        
        #接続lineを移動
        if len(self.lineids):
          undodata.extend(self.withlines())
        global undolist
        undolist.append(['MOV','BOX',undodata])
        #変更
        set_modified()

    #xmov,ymovともに0のときは参考ボックス表示
    if self.xmov==0 and self.ymov==0:
      bxdistx = self.skukei[0]-self.kukei[0]
      bxdisty = self.skukei[1]-self.kukei[1]
      ptdistx = self.evx-self.x
      ptdisty = self.evy-self.y
      if abs(ptdistx)<=40:
        sxmov = ptdistx-bxdistx
      else:
        sxmov = 40-bxdistx if ptdistx>=0 else -40-bxdistx
      if abs(ptdisty)<=40:
        symov = ptdisty-bxdisty
      else:
        symov = 40-bxdisty if ptdisty>=0 else -40-bxdisty
      canvas.move(self.skuid,sxmov,symov)
      self.skukei = canvas.coords(self.skuid)

    self.x += self.xmov
    self.y += self.ymov
    self.kukei = canvas.coords(self.kuid)

  #移動後マウス１リリースで参考矩形消去
  def b1release(self,event):
    if mode.get() != 'Nor':
      return
    if len(self.skukei):
      canvas.delete(self.skuid)
      self.skukei = []
    
  #Box移動後に接続しているラインも移動
  def withlines(self):
    undodata = []
    for laid in self.lineids:
      l1 = get_sozokulist('aid',laid)
      #laidのLineが夫婦ラインの場合
      if l1[0].twoof=='fuhu':
        #laidが接続する他方のBoxのaid取得
        boxaid = l1[0].frtoids[0] if l1[0].frtoids[1]==self.absid \
                 else l1[0].frtoids[1]
        #他boxの座標取得
        tbox = get_sozokulist('aid',boxaid)
        tboxcoords = canvas.coords(tbox[1])
        #line座標を再計算
        fst = [KukeiOBJ,self.absid,canvas.coords(self.kuid)]
        snd = [KukeiOBJ,boxaid,tboxcoords]
        fuhunew = calclinecoords('fuhu',fst,snd)
        #Undo情報
        undodata.append(['LINE',laid,canvas.coords(l1[1])])
        #line描画
        canvas.coords(l1[1],*fuhunew)
        ##（以下は夫婦ラインを移動する場合に通じる）
        #再描画した夫婦ラインと親子ラインの接続点計算
        # ※ｘ方向の中央がxspaceでないときは、+xsize/2+xspace/2の位置のx,y座標
        fx,fy = get_fuhuline_cpoint(fuhunew)

        for klaid in l1[0].lineids:
          #klaidの接続先のaidからBoxの座標取得
          k1 = get_sozokulist('aid',klaid)
          boxaid = k1[0].frtoids[0] if k1[0].frtoids[1]==laid \
                   else k1[0].frtoids[1]
          tbox = get_sozokulist('aid',boxaid)
          tboxcoords = canvas.coords(tbox[1])
          #line座標計算
          fst = [LineOBJ,laid,[fx,fy]]
          snd = [KukeiOBJ,boxaid,tboxcoords]
          oyakonew = calclinecoords('oyako',fst,snd)
          #Undo情報
          undodata.append(['LINE',klaid,canvas.coords(k1[1])])
          #line再描画
          canvas.coords(k1[1],*oyakonew)
      #laidのLineが親子ラインの場合
      else:
        #laidのlineが接続する他方の接続先aidを取得
        if l1[0].frtoids[1]==self.absid:
          iam = 'ko'
          blaid = l1[0].frtoids[0]
        else:
          iam = 'oya'
          blaid = l1[0].frtoids[1]
        bl1 = get_sozokulist('aid',blaid)
        #他方もBoxの場合（fst:親、snd:子）
        if bl1[0].type == 'box':
          #他方Boxの矩形座標を取得
          boxcoords = canvas.coords(bl1[1])
          #Boxと他方Boxの間のLine座標を計算
          if iam=='oya':
            fst = [KukeiOBJ,self.absid,canvas.coords(self.kuid)]
            snd = [KukeiOBJ,blaid,boxcoords]
          else: #iam=='ko'
            fst = [KukeiOBJ,blaid,boxcoords]
            snd = [KukeiOBJ,self.absid,canvas.coords(self.kuid)]
          newcoords = calclinecoords('oyako',fst,snd)
        #他方がLineの場合
        else: #'line'
          #夫婦Lineとの接続点座標を取得
          end1,end2 = get_linecoords_both_ends(canvas.coords(l1[1]))
          if is_on_line(end1,canvas.coords(bl1[0].lineid)):
            fstcoord = end1
          elif is_on_line(end2,canvas.coords(bl1[0].lineid)):
            fstcoord = end2
          else:
            #夫婦ラインと接していない
            fstcoord = get_fuhuline_cpoint(fuhunew)
          #line接続点とBox間のLine座標を計算
          fst = [LineOBJ,blaid,fstcoord]
          snd = [KukeiOBJ,self.absid,canvas.coords(self.kuid)]
          newcoords = calclinecoords('oyako',fst,snd)
        #Undo情報
        undodata.append(['LINE',laid,canvas.coords(l1[1])])
        #line描画
        canvas.coords(l1[1],*newcoords)
    return undodata

  #現在の矩形位置でkukeiアトリビュートを更新する
  def setcoords(self):
    self.kukei = canvas.coords(self.kuid)

  #Boxのダブルクリックをここで受ける
  def sozoku_doubleclick(self,event):
    undata = self.sozoku_edit()
    if len(undata) and not undo_flg:
      global undolist
      undolist.append(undata)
      #変更
      set_modified()
      
  #相続人データの表示
  #原則数字文字表示は半角組文字表示とする。
  #　半角組文字表示が不都合なら’＃＃’で全角処理
  def show_sozoku(self):
    #相続データ入力結果の表示（再描画の際に以前の表示を消す）
    #if self.atrb:
    canvas.delete(str(self.absid)+'atrb')
    #縦書テキストのアンカーを使う
    #続柄
    tl = self.tate_zoku.split("\n")
    x = self.kukei[2]-self.size_zoku
    y = self.kukei[1]+fntsp
    fh = int(self.size_zoku * dpi / ppi)
    for tlt in tl:
      canvas.create_text(x,y,text=tlt,font=self.zokufont,anchor='n',
                         fill=self.zoku_color,
                         tags=('sozoku','box','zoku',str(self.absid)+'atrb'))
      #y += (self.size_zoku+fntsp)
      y += fh

    #氏名（センター配置）
    fh = int(self.size_name * dpi / ppi)
    tct = 0
    #最大文字数
    for nl in self.tate_name:
      tct = len(nl.split()) if len(nl.split())>=tct else tct
    #表示の上端
    y0 = self.kukei[1]+ysize/2 - int(tct*fh/2)
    if len(self.tate_name)>=2:
      if len(self.tate_name)%2:  #奇数行
        x = self.kukei[0]+xsize/2 + ((len(self.tate_name)-1)/2)*fh
      else:  #偶数行
        x = self.kukei[0]+xsize/2 + (len(self.tate_name)/2)*fh/2
    else:  #1行以下
      x = self.kukei[0]+xsize/2
    for nl in self.tate_name:
      y = y0
      for tx in nl.split('\n'):
        canvas.create_text(x,y,text=tx,font=self.namefont,anchor='n',
                           fill=self.name_color,
                           tags=('sozoku','box','name',str(self.absid)+'atrb'))
        y += fh
      x -= fh
##    tl=self.tate_name.split("\n")
##    x = self.kukei[0]+xsize/2 - \
##        int((len(tl[0])*self.size_name + (len(tl[0])-1)*fntsp)/2)
##    fh = int(self.size_name * dpi / ppi)
##    y = self.kukei[1]+ysize/2 - int(len(tl)*fh/2)
##    for tlt in tl:
##      canvas.create_text(x,y,text=tlt,font=self.namefont,anchor='nw',
##                         fill=self.name_color,
##                         tags=('sozoku','box','name',str(self.absid)+'atrb'))
##      y += fh
    #生年月日
    lst= self.tate_birth.split("\n")
    x = self.kukei[2]-self.size_birth
    self.dateshow(lst,x,self.size_birth,self.birthfont,'birth',self.birth_color)
    #self.dateshow(self.tate_birth,x,self.size_birth,self.birthfont,'birth',self.birth_color)

    #死亡年月日
    lst = self.tate_die.split("\n")
    x = self.kukei[0]+self.size_die
    self.dateshow(lst,x,self.size_die,self.diefont,'die',self.die_color)
    #self.dateshow(self.tate_die,x,self.size_die,self.diefont,'die',self.die_color)

    #住所
    fh = int(self.size_addr * dpi / ppi)
    #表示の上端
    y0 = self.kukei[1]+norkon_ys+fntsp
    #住所文字列右端
    x = self.kukei[2]+fh/2+(len(self.tate_addr)-1)*fh+fntsp
    for nl in self.tate_addr:
      y = y0
      for tx in nl.split():
        canvas.create_text(x,y,text=tx,font=self.addrfont,anchor='n',
                           fill=self.addr_color,
                           tags=('sozoku','box','addr',str(self.absid)+'atrb'))
        y += fh
      x -= fh

##    tl = self.tate_addr.split("\n")
##    x = self.kukei[2]+fntsp
##    y = self.kukei[1]+norkon_ys+fntsp
##    fh = int(self.size_addr * dpi / ppi)
##    for tlt in tl:
##      canvas.create_text(x,y,text=tlt,font=self.addrfont,anchor='nw',
##                         fill=self.addr_color,
##                         tags=('sozoku','box','addr',str(self.absid)+'atrb'))
##      y += fh

  #日付文字列表示の共通処理
  #数字文字を半角の組文字表示にする。
  #西暦年を上２桁下２桁でｘ座標をずらさないように簡便化。
  #それに伴いtatedatestr関数も西暦年4桁を2桁ずつに分離して返すように変更。
  #同時に１文字毎に出力していたのをマルチラインとして出力するよう簡便化したが
  #svg出力の際にマルチラインを認識しないので元の１文字毎出力に戻した。
  def dateshow(self,tl,x,size,fnt,dname,colorcode):
    imx = 0
    for i in tl:
      icnt = len(i)
      imx = icnt if icnt>imx else imx
    fn = int(size * dpi / ppi)
    if imx == 4:   #西暦年の可能性 ２桁２段で表示するのでY座標を１文字分調整
      y = self.kukei[3]-(fn*(len(tl)+1)+fntsp)
    else:
      y = self.kukei[3]-(fn*len(tl)+fntsp)
    for tlt in tl:
      if len(tlt)==4:   #西暦年表示
        canvas.create_text(x,y,text=tlt[0:2],font=fnt,
                           anchor='n',fill=colorcode,
                           tags=('sozoku','box',dname,str(self.absid)+'atrb'))
        y += fn
        canvas.create_text(x+fntsp,y,text=tlt[2:4],font=fnt,
                           anchor='n',fill=colorcode,
                           tags=('sozoku','box',dname,str(self.absid)+'atrb'))
        y += fn
      else:
        canvas.create_text(x,y,text=tlt,font=fnt,anchor='n',fill=colorcode,
                           tags=('sozoku','box',dname,str(self.absid)+'atrb'))
        y += fn

##  def dateshow(self,tl,x,size,fnt,dname,colorcode):
##    fn = int(size * dpi / ppi)
##    y = self.kukei[3]-(fn*len(tl.split())+fntsp)
##    canvas.create_text(x,y,text=tl,font=fnt,anchor='n',fill=colorcode,
##                       justify=CENTER,
##                       tags=('sozoku','box',dname,str(self.absid)+'atrb'))
#-------------------------------------------------class Sozoku end

#---------------------------------------------------------
#相続人アトリビュート入力ダイアログ      class Sozoku_dialog
#　（続柄、生年月日、氏名、死亡年月日、住所）
#---------------------------------------------------------
#タイトルは呼び出し時に引数で指定する
class Sozoku_dialog(simpledialog.Dialog):
  #入力ダイアログの表示
  def body(self,master):
    self.result = []  #承継元のアトリビュートを上書き
    #IME制御
    self.imesetted = []   #IMEをONにしたwidgetリスト
    #続柄
    self.entry_zoku = self.mk_entry("続　　柄",human[0],0,master)
    #氏名
    self.text_name = self.mk_text_entry("氏　　名",human[1],1,master)
    #生年月日
    self.entry_birth = self.mk_entry("生年月日",human[2],4,master)
    #死亡年月日
    self.entry_die = self.mk_entry("死亡年月日",human[3],5,master)
    #住所
    self.text_addr = self.mk_text_entry("住　　所",human[4],6,master)
    
    self.entry_zoku.focus_set()
    return self.entry_zoku # initial focus

  #複数行入力のテキストエントリー作成の共通処理
  def mk_text_entry(self,ttl,strdata,num,master):
    Label(master,text=ttl,font=labelfont).grid(row=num,rowspan=3)
    text_entry = Text(master,width=30,height=3,font=entryfont)
    text_entry.delete(1.0,END)
    text_entry.insert(END,strdata)
    text_entry.grid(row=num,rowspan=3,column=1,columnspan=2)
    #IME制御
    #if not cursys == 'Windows':
    if chkres['xte']:
      text_entry.bind('<FocusIn>',self.focusin)
    #Tab制御
    text_entry.bind('<Tab>',self.focustonext)
    return text_entry

  #１行入力のエントリー作成の共通処理
  def mk_entry(self,ttl,strdate,num,master):
    Label(master,text=ttl,font=labelfont).grid(row=num)
    entry = Entry(master,width=30,font=entryfont)
    entry.delete(0,END)
    entry.insert(0,strdate)
    entry.grid(row=num,column=1,columnspan=2,padx=2,pady=2)
    #IME制御
    #if not cursys == 'Windows':
    if chkres['xte']:   #'xte'がシステムに存在していれば
      entry.bind('<FocusIn>',self.focusin)
    return entry

  #IME制御（Windows環境を除く）
  def focusin(self,event):
    if not event.widget in self.imesetted:
      control_space_sequence = \
                'keydown Control_L\nkey Space\nkeyup Control_L\n'
##      control_space_sequence = '''keydown Control_L
##key Space
##keyup Control_L
##'''
      control_space_sequence = control_space_sequence.encode('utf-8')
      try:
        p = Popen(['xte'], stdin=PIPE, stdout=PIPE,stderr=PIPE)
        p.communicate(input=control_space_sequence)
      except (ChildProcessError,FileNotFoundError):
        pass
      self.imesetted.append(event.widget)
    else:
      return

  #テキストエントリー内のタブキー制御
  def focustonext(self,event):
    event.widget.tk_focusNext().focus()
    return("break")

  def apply(self):
    zoku = self.entry_zoku.get()
    name = self.text_name.get(1.0,END)
    name = name.strip()   #空行削除
    birth = self.entry_birth.get()
    die = self.entry_die.get()
    addr = self.text_addr.get(1.0,END)
    addr = addr.strip()   #空行を削除
    #全角縦書に変換
    zokutate = zentategaki(zoku)
    #nametate = zentategaki(name)
    nametate = memotatenaka(name)
    birthtate = tatedatestr(birth)
    dietate = tatedatestr(die)
    #addrtate = zentategaki(addr)
    addrtate = memotatenaka(addr)
    self.result = [[zoku,name,birth,die,addr],
                   [zokutate,nametate,birthtate,dietate,addrtate]]

  #入力中に改行する必要があるのでエンターキーのバインドを外した
  def buttonbox(self):
    box = Frame(self)
    w = Button(box, text="OK", width=10, command=self.ok)
    w.pack(side=LEFT, padx=5, pady=5)
    w = Button(box, text="Cancel", width=10, command=self.cancel)
    w.pack(side=LEFT, padx=5, pady=5)
    #self.bind("<Return>", self.ok)
    self.bind("<Escape>", self.cancel)
    box.pack()
#------------------------------------- class Sozoku_dialog  end

#---------------------------------------------------------
#相続BOXスタイル入力               class SozokuLooks_dialog
#---------------------------------------------------------
class SozokuLooks_dialog(simpledialog.Dialog):
  def body(self,master):
    #sizelist= [[zoku_size,zoku_bold,zoku_italic],[name_size,name_bold,name_italic],
    #          [birth_size,birth_bold,birth_italic],[die_size,die_bold,die_italic],
    #          [addr_size,addr_bold,addr_italic]]
    #colorlist = [self.zoku_color,self.name_color,self.birth_color,
    #             self.die_color,self.addr_color,self.outline_color,
    #             self.bg_color]
    #outline_style_list = [self.dashptn,self.outlinewidth]
    #diag_list = [self.diagline,self.diagwidth,self.diagptrn,self.diagcolor]
    
    self.result = []  #承継元のアトリビュートを上書き
    #入力値検証関数のラッパー
    self.wrap_is_valid = master.register(self.is_valid)
    self.wrap_invalid = master.register(self.invalid)
    self.wrap_is_valid_dash = master.register(self.is_valid_dash)
    self.wrap_invalid_dash = master.register(self.invalid_dash)
    self.parent = master
    
    Label(master,text='項　目',font=labelfont).grid(row=0)
    Label(master,text='サイズ',font=labelfont).grid(row=0,column=1)
    Label(master,text='スタイル',font=labelfont).grid(row=0,column=2,columnspan=2)
    Label(master,text='カラー',font=labelfont).grid(row=0,column=4)
    #続柄
    self.chk_zoku_bold = IntVar()
    self.chk_zoku_ital = IntVar()
    self.zoku_color_str = colorlist[0]
    self.zoku_entry,self.zokubtn = self.mk_entry('続柄',sizelist[0],1,
                                    self.chk_zoku_bold,self.chk_zoku_ital,
                                    self.zoku_color_str,master)
    #氏名
    self.chk_name_bold = IntVar()
    self.chk_name_ital = IntVar()
    self.name_color_str = colorlist[1]
    self.name_entry,self.namebtn = self.mk_entry('氏名',sizelist[1],2,
                                    self.chk_name_bold,self.chk_name_ital,
                                    self.name_color_str,master)
    #生年月日
    self.chk_birth_bold = IntVar()
    self.chk_birth_ital = IntVar()
    self.birth_color_str = colorlist[2]
    self.birth_entry,self.birthbtn = self.mk_entry('生年月日',sizelist[2],3,
                                     self.chk_birth_bold,self.chk_birth_ital,
                                     self.birth_color_str,master)
    #死亡日付
    self.chk_die_bold = IntVar()
    self.chk_die_ital = IntVar()
    self.die_color_str = colorlist[3]
    self.die_entry,self.diebtn = self.mk_entry('死亡年月日',sizelist[3],4,
                                   self.chk_die_bold,self.chk_die_ital,
                                   self.die_color_str,master)
    #住所
    self.chk_addr_bold = IntVar()
    self.chk_addr_ital = IntVar()
    self.addr_color_str = colorlist[4]
    self.addr_entry,self.addrbtn = self.mk_entry('住所',sizelist[4],5,
                                    self.chk_addr_bold,self.chk_addr_ital,
                                    self.addr_color_str,master)
    Label(master,text='───────────────────',
          font=labelfont).grid(row=6,column=0,columnspan=5)
    #線幅
    self.width_entry = self.mk_outline_entry('外枠線幅',
                                             outline_style_list[1],7,2,master)
    #線の色
    Label(master,text='外枠線',font=labelfont).grid(row=7,column=2,columnspan=2)
    self.line_color_str = colorlist[5]
    self.linebtn = Button(master,text=self.line_color_str,
                          fg=self.line_color_str,width=8,
                          command=lambda:self.getcolor(
                            self.line_color_str,'枠線',master))
    self.linebtn.grid(row=7,column=4)
    #破線パターン
    ptnstr = ','.join([str(x) for x in outline_style_list[0]])
    self.dash_entry = self.mk_outline_entry('破線形状',ptnstr,8,5,master)
    #ボックス内部の色
    Label(master,text='背景',font=labelfont).grid(row=8,column=2,columnspan=2)
    self.bg_color_str=colorlist[6]
    self.bgbtn=Button(master,text=self.bg_color_str,
                      fg=self.bg_color_str,width=8,
                      command=lambda:self.getcolor(
                        self.bg_color_str,'背景',master))
    self.bgbtn.grid(row=8,column=4)

    Label(master,text='───────────────────',
          font=labelfont).grid(row=9,column=0,columnspan=5)
    #斜線種別
    Label(master,text='斜線',font=labelfont).grid(row=10,column=0)
    self.diagvar = IntVar()
    self.diagvar.set(diag_list[0])
    frame = Frame(master)
    Radiobutton(frame,text='なし',
                variable=self.diagvar,value=no_diag).pack(side=LEFT)
    Radiobutton(frame,text='左下り',
                variable=self.diagvar,value=l_diag).pack(side=LEFT)
    Radiobutton(frame,text='右下り',
                variable=self.diagvar,value=r_diag).pack(side=LEFT)
    Radiobutton(frame,text='両方',
                variable=self.diagvar,value=both_diag).pack(side=LEFT)
    frame.grid(row=10,column=1,columnspan=4,sticky=W)
    
    #斜線幅
    self.diagwd_entry = self.mk_outline_entry('斜線幅',
                                              diag_list[1],11,2,master)
    #斜線色
    Label(master,text='斜線',font=labelfont).grid(row=11,column=2,columnspan=2)
    self.diagcol_str = diag_list[3]
    self.diagbtn = Button(master,text=self.diagcol_str,
                          fg=self.diagcol_str,width=8,
                          command=lambda:self.getcolor(self.diagcol_str,
                                                       '斜線',master))
    self.diagbtn.grid(row=11,column=4)
    #斜線パターン
    ptnstr = ','.join([str(x) for x in diag_list[2]])
    self.diagptrn_entry = self.mk_outline_entry('破線形状',ptnstr,12,5,master)
    #破線パターンの説明
    Label(master,text='※draw_times,skip_times,・・',
          font=labelfontmini).grid(row=13,column=0,columnspan=3,sticky=NW)
    #既定値設定ボタン
    self.mk_setto_default_btn(master)
    #既定値読み込み
    self.mk_getfrom_default_btn(master)
    #初期化ボタン
    Button(master,text='初期値に戻す',bg='white',fg='black',
           command=lambda:self.init_style(master)).grid(row=14,column=3,
                                                        columnspan=2,sticky=E)
    self.zoku_entry.focus_set()
    return self.zoku_entry # initial focus

  #各入力項目を規定値に戻すボタン
  def mk_getfrom_default_btn(self,master):
    Button(master,text='既定値に戻す',bg='white',fg='black',
           command=lambda:self.init_default_style(master)).\
           grid(row=15,column=3,columnspan=2,sticky=E)

  #現在の入力項目の値を規定値とするボタン
  def mk_setto_default_btn(self,master):
    Button(master,text='既定値に設定する',
           command=self.set_default_style).grid(row=15,column=0,
                                                        columnspan=2,sticky=W)
  #Box外枠線の形状等のエントリー作成
  def mk_outline_entry(self,ttl,orgstr,num,wth,master):
    Label(master,text=ttl,font=labelfont).grid(row=num,column=0)
    if ttl=='破線形状':
      entry = Entry(master,width=wth,font=entryfont,
                    validate='all',
                    validatecommand=(self.wrap_is_valid_dash,'%P','%V','%W'),
                    invalidcommand=(self.wrap_invalid_dash,'%W'))
    else:
      entry = Entry(master,width=wth,font=entryfont,
                    validate='all',
                    validatecommand=(self.wrap_is_valid,'%P','%V','%W'),
                    invalidcommand=(self.wrap_invalid,'%W'))
    entry.delete(0,END)
    entry.insert(0,orgstr)
    entry.grid(row=num,column=1,padx=2,pady=2)
    return entry

  #氏名、住所等の文字スタイルのエントリー作成
  def mk_entry(self,ttl,orglst,num,boldvar,italvar,colorstr,master):
    Label(master,text=ttl,font=labelfont).grid(row=num,sticky=E)
    entry = Entry(master,width=2,font=entryfont,
                  validate='all',
                  validatecommand=(self.wrap_is_valid,'%P','%V','%W'),
                  invalidcommand=(self.wrap_invalid,'%W'))
    entry.delete(0,END)
    entry.insert(0,orglst[0])
    entry.grid(row=num,column=1,padx=2,pady=2)
    boldvar.set(orglst[1])
    italvar.set(orglst[2])
    d=Checkbutton(master, text="太字", variable=boldvar)
    d.grid(row=num,column=2)
    e=Checkbutton(master, text="斜体", variable=italvar)
    e.grid(row=num,column=3)
    button = Button(master,text=colorstr, fg=colorstr, width=8,
                    command=lambda:self.getcolor(colorstr,ttl,master))
    button.grid(row=num,column=4)
    return [entry,button]

  #入力値のチェック
  def is_valid(self,value,reason,wd):
    if reason=='focusout':
      if re.match('^[1-9][0-9]??$',value):
        return True
      else:
        return False
    else:
      return True

  #入力値が不正なら
  def invalid(self,wd):
    messagebox.showerror('入力エラー','1〜99までの値を半角で')
    #self.parent.nametowidget(wd).focus_set()
    self.initial_focus.focus_set()

  #破線パターンの文字チェック
  def is_valid_dash(self,value,reason,wd):
    if reason=='focusout':
      if re.match('^([1-9],)+[1-9]$',value):
        return True
      else:
        if not len(value):  #入力なしも認める
          return True
        else:
          return False
    else:
      return True

  #破線パターン文字列が不正なら
  def invalid_dash(self,wd):
    messagebox.showerror('入力エラー',
                         '描画ドット数と空白ドット数を半角カンマ区切りで')
    #self.parent.nametowidget(wd).focus_set()
    self.initial_focus.focus_set()

  #OKボタンが押された
  def ok(self, event=None):
    if not self.validate():
      self.initial_focus.focus_set() # put focus back
      return
    self.withdraw()
    self.update_idletasks()

    try:
      self.apply()
    finally:
      self.cancel()

  #OKボタンが押されたときに入力値のチェック
  def validate(self):
    def rematch(ent):
      if not re.match('^[1-9][0-9]??$',ent):
        messagebox.showerror('入力エラー','1〜99までの半角数字')
        return False
      else:
        return True
    def rematchdash(ent):
      if len(ent):
        if not re.match('^([1-9],)+[1-9]$',ent):
          messagebox.showerror('入力エラー',
                               '描画ドット数と空白ドット数を半角カンマ区切りで')
          return False
        else:
          return True
      return True
    
    e1 = self.zoku_entry.get().strip()
    e2 = self.name_entry.get().strip()
    e3 = self.birth_entry.get().strip()
    e4 = self.die_entry.get().strip()
    e5 = self.addr_entry.get().strip()
    e6 = self.width_entry.get().strip()
    e7 = self.diagwd_entry.get().strip()
    if not rematch(e1) or not rematch(e2) or \
       not rematch(e3) or not rematch(e4) or \
       not rematch(e5) or not rematch(e6) or not rematch(e7):
      return False
    de1 = self.dash_entry.get().strip()
    de2 = self.diagptrn_entry.get().strip()
    if not rematchdash(de1) or not rematchdash(de2):
        return False
    return True

  #入力値を既定値に設定する
  def set_default_style(self):
    #現在の値を既定値に登録
    oldstyles = set_default_box_styles(self.read_entry())
    #undo情報
    global undolist
    undolist.append(['CHGBOXDEF','ALL',oldstyles])

  #既定値に戻す
  def init_default_style(self,master):
    stylelist = default_box_styles
    self.set_entry(master,stylelist)
    
  #初期値に戻す
  def init_style(self,master):
    stylelist = box_init_style()
    self.set_entry(master,stylelist)

  #各入力エントリーに現在の値をセット
  def set_entry(self,master,stylelist):
    #[[size_zoku,zoku_bold,zoku_italic],[size_name,name_bold,name_italic],
    # [size_birth,birth_bold,birth_italic],[size_die,die_bold,die_italic],
    # [size_addr,addr_bold,addr_italic],[dashptn,outlinewidth],
    # [zoku_color,name_color,birth_color,die_color,addr_color,outline_color,bg_color],
    # [diagline,diagwidth,diagptrn,diagcolor]]
    self.init_entry(self.zoku_entry,self.chk_zoku_bold,self.chk_zoku_ital,stylelist[0])
    self.init_entry(self.name_entry,self.chk_name_bold,self.chk_name_ital,stylelist[1])
    self.init_entry(self.birth_entry,self.chk_birth_bold,self.chk_birth_ital,stylelist[2])
    self.init_entry(self.die_entry,self.chk_die_bold,self.chk_die_ital,stylelist[3])
    self.init_entry(self.addr_entry,self.chk_addr_bold,self.chk_addr_ital,stylelist[4])
    self.dash_entry.delete(0,END)
    #self.dash_entry.insert(0,stylelist[5][0])
    ptnstr = ','.join([str(x) for x in stylelist[5][0]])
    self.dash_entry.insert(0,ptnstr)
    self.width_entry.delete(0,END)
    self.width_entry.insert(0,stylelist[5][1])
    self.diagvar.set(stylelist[7][0])
    self.diagwd_entry.delete(0,END)
    self.diagwd_entry.insert(0,stylelist[7][1])
    self.diagptrn_entry.delete(0,END)
    ptnstr = ','.join([str(x) for x in stylelist[7][2]])
    self.diagptrn_entry.insert(0,ptnstr)
    self.zoku_color_str = self.init_color(self.zokubtn,stylelist[6][0],'続柄',master)
    self.name_color_str = self.init_color(self.namebtn,stylelist[6][1],'氏名',master)
    self.birth_color_str = self.init_color(self.birthbtn,stylelist[6][2],'生年月日',master)
    self.die_color_str = self.init_color(self.diebtn,stylelist[6][3],'死亡年月日',master)
    self.addr_color_str = self.init_color(self.addrbtn,stylelist[6][4],'続柄',master)
    self.line_color_str = self.init_color(self.linebtn,stylelist[6][5],'枠線',master)
    self.bg_color_str = self.init_color(self.bgbtn,stylelist[6][6],'背景',master)
    self.diagcol_str = self.init_color(self.diagbtn,stylelist[7][3],'斜線',master)

  #ボタン上の文字色を現在の色で表示
  def init_color(self,btn,color,ttl,master):
    #文字列はタプル同様変更不可なので参照渡しであっても元の値が保持される。
    #colorstr = color　従って、このように文字列の引数に代入をしても元の値は変更されない。
    btn.configure(text=color,fg=color,
                  command=lambda:self.getcolor(color,ttl,master))
    return color

  #入力エントリーに値をセット
  def init_entry(self,entry,boldvar,italvar,stylst):
    entry.delete(0,END)
    entry.insert(0,stylst[0])
    boldvar.set(stylst[1])
    italvar.set(stylst[2])

  #ラムダで呼ぶ際にはevent必要なし？
  #color選択ダイアログで表示色を選択
  def getcolor(self,colorstr,ttl,master):
    rescolor = colorchooser.askcolor(parent=master,initialcolor=colorstr,
                                     title=ttl+'：カラー選択')
    if not rescolor[0]==None:
      colorstr = rescolor[1]
      #ボタン表示、色変更
      obj = ''
      if ttl=='続柄':
        obj = self.zokubtn
        self.zoku_color_str = colorstr
      elif ttl=='氏名':
        obj = self.namebtn
        self.name_color_str = colorstr
      elif ttl=='生年月日':
        obj = self.birthbtn
        self.birth_color_str = colorstr
      elif ttl=='死亡年月日':
        obj = self.diebtn
        self.die_color_str = colorstr
      elif ttl=='住所':
        obj = self.addrbtn
        self.addr_color_str = colorstr
      elif ttl=='枠線':
        obj = self.linebtn
        self.line_color_str = colorstr
      elif ttl=='背景':
        obj=self.bgbtn
        self.bg_color_str = colorstr
      elif ttl=='斜線':
        obj=self.diagbtn
        self.diagcol_str = colorstr
      if obj:
        obj.configure(text=colorstr,fg=colorstr,
                      command=lambda:self.getcolor(colorstr,ttl,master))
  
  #破線形状と線幅
  def ptrn_width(self,ptrn,wd):
    #枠線
    #daptn = self.dash_entry.get()
    if len(ptrn):
      retptn=[int(x) for x in ptrn.split(',')]
      #ドット数0は１に置き換える
      retptn=[1 if x==0 else x for x in retptn]
    else:
      retptn=[]
    #wd = self.width_entry.get()
    if len(wd):
      retwd = int(wd)
      retwd = 1 if retwd==0 else retwd
    else:
      retwd = 1
    return [retptn,retwd]

  #各入力エントリーの値を取得
  def read_entry(self):
    retptn,retwd = self.ptrn_width(self.dash_entry.get(),self.width_entry.get())
    diagptn,diagwd = self.ptrn_width(self.diagptrn_entry.get(),self.diagwd_entry.get())
    
    res = [[int(self.zoku_entry.get()),self.chk_zoku_bold.get(),
            self.chk_zoku_ital.get(),self.zoku_color_str],
           [int(self.name_entry.get()),self.chk_name_bold.get(),
            self.chk_name_ital.get(),self.name_color_str],
           [int(self.birth_entry.get()),self.chk_birth_bold.get(),
            self.chk_birth_ital.get(),self.birth_color_str],
           [int(self.die_entry.get()),self.chk_die_bold.get(),
            self.chk_die_ital.get(),self.die_color_str],
           [int(self.addr_entry.get()),self.chk_addr_bold.get(),
            self.chk_addr_ital.get(),self.addr_color_str],
           [retptn,retwd,self.line_color_str,self.bg_color_str],
           [self.diagvar.get(),diagwd,diagptn,self.diagcol_str]]
    return res

  #OKボタンで入力を受け入れる
  def apply(self):
    self.result = self.read_entry()
##    retptn,retwd = self.ptrn_width(self.dash_entry.get(),self.width_entry.get())
##    diagptn,diagwd = self.ptrn_width(self.diagptrn_entry.get(),self.diagwd_entry.get())
##    
##    self.result = [[int(self.zoku_entry.get()),self.chk_zoku_bold.get(),
##                    self.chk_zoku_ital.get(),self.zoku_color_str],
##                   [int(self.name_entry.get()),self.chk_name_bold.get(),
##                    self.chk_name_ital.get(),self.name_color_str],
##                   [int(self.birth_entry.get()),self.chk_birth_bold.get(),
##                    self.chk_birth_ital.get(),self.birth_color_str],
##                   [int(self.die_entry.get()),self.chk_die_bold.get(),
##                    self.chk_die_ital.get(),self.die_color_str],
##                   [int(self.addr_entry.get()),self.chk_addr_bold.get(),
##                    self.chk_addr_ital.get(),self.addr_color_str],
##                   [retptn,retwd,self.line_color_str,self.bg_color_str],
##                   [self.diagvar.get(),diagwd,diagptn,self.diagcol_str]]

  #入力中に改行する必要があるのでエンターキーのバインドを外した
  def buttonbox(self):
    box = Frame(self)
    w = Button(box, text="OK", width=10, command=self.ok)
    w.pack(side=LEFT, padx=5, pady=5)
    w = Button(box, text="Cancel", width=10, command=self.cancel)
    w.pack(side=LEFT, padx=5, pady=5)
    #self.bind("<Return>", self.ok)
    self.bind("<Escape>", self.cancel)
    box.pack()
#------------------------------------- class SozokuLooks_dialog  end

#-------------------------------class SozokuDefaultLooks_dialog start
#相続Boxスタイルの既定値を編集するダイアログ
#（ SozokuLooks_dialogから承継 ）
#----------------------------------------
class SozokuDefaultLooks_dialog(SozokuLooks_dialog):
  #不要ボタン設定をpassで上書き
  def mk_setto_default_btn(self,master):
    pass
##  def mk_getfrom_default_btn(self,master):
##    pass
  def set_default_style(self,master):
    pass
#-------------------------------class SozokuDefaultLooks_dialog end

#-------------------------------------------------------------------
#boxの文字サイズ、スタイル、枠線、背景などの初期値を配列にして返す
def box_init_style():
  #[[size_zoku,zoku_bold,zoku_italic],[size_name,name_bold,name_italic],
  # [size_birth,birth_bold,birth_italic],[size_die,die_bold,die_italic],
  # [size_addr,addr_bold,addr_italic],[dashptn,outlinewidth],
  # [zoku_color,name_color,birth_color,die_color,addr_color,outline_color,bg_color],
  # [diagline,diagwidth,diagptrn,diagcolor]]
  return [[size_da,0,0],[size_na,0,0],
          [size_da,0,0],[size_da,0,0],
          [size_ad,0,0],[[],1],
          [defcolor,defcolor,defcolor,defcolor,defcolor,defcolor,kucolor],
          [no_diag,1,[],defcolor] ]

#-------------------------------------------------------------------
#引数resのスタイルをBoxスタイルの規定値に設定する
def set_default_box_styles(res):
  ##    res = [[int(self.zoku_entry.get()),self.chk_zoku_bold.get(),
  ##            self.chk_zoku_ital.get(),self.zoku_color_str],
  ##           [int(self.name_entry.get()),self.chk_name_bold.get(),
  ##            self.chk_name_ital.get(),self.name_color_str],
  ##           [int(self.birth_entry.get()),self.chk_birth_bold.get(),
  ##            self.chk_birth_ital.get(),self.birth_color_str],
  ##           [int(self.die_entry.get()),self.chk_die_bold.get(),
  ##            self.chk_die_ital.get(),self.die_color_str],
  ##           [int(self.addr_entry.get()),self.chk_addr_bold.get(),
  ##            self.chk_addr_ital.get(),self.addr_color_str],
  ##           [retptn,retwd,self.line_color_str,self.bg_color_str],
  ##           [self.diagvar.get(),diagwd,diagptn,self.diagcol_str]]
  ##引数のリスト順と既定値リスト順が異なる
  global default_box_styles
  #undodataをtupleで作成しないと書き換わってしまうので（pythonの仕様）
  undodata = tuple(default_box_styles)
  for idx in range(0,5):
    default_box_styles[idx]=res[idx][0:3]
  default_box_styles[5]=res[5][0:2]
  default_box_styles[6] = [res[i][3] for i in range(0,5)]
  default_box_styles[6].extend([res[5][2],res[5][3]])
  default_box_styles[7]=[res[6][i] for i in range(0,4)]
  #変更
  set_modified()
  messagebox.showinfo('スタイルの既定値',
                      'Boxスタイルの既定値を変更しました。')
  return list(undodata)

#----------------------------------------------------------
#既存のBoxスタイルを一括して変更する
  #[[size_zoku,zoku_bold,zoku_italic],[size_name,name_bold,name_italic],
  # [size_birth,birth_bold,birth_italic],[size_die,die_bold,die_italic],
  # [size_addr,addr_bold,addr_italic],[dashptn,outlinewidth],
  # [zoku_color,name_color,birth_color,die_color,addr_color,outline_color,bg_color],
  # [diagline,diagwidth,diagptrn,diagcolor]]
def box_style_all():
  #初期値をグローバル変数にセットして
  global sizelist
  global outline_style_list
  global colorlist
  global diag_list
  global boxlookslist
  global undolist
  stylelist = box_init_style()
  sizelist = stylelist[0:5]
  outline_style_list = stylelist[5]
  colorlist = stylelist[6]
  diag_list = stylelist[7]
  #Boxがあるかどうか
  boxlist = canvas.find_withtag('box')
  if not len(boxlist):
    messagebox.showinfo('Boxスタイル設定','Boxが登録されていません。')
    return
  #スタイル入力ダイアログを呼び出し
  styinsta = SozokuLooks_dialog(canvas,'ボックス表示一括変更')
  #OKで戻ってきたら、結果をグローバル変数にセットして
  if len(styinsta.result):
    boxlookslist = styinsta.result
  else:
    return
  #Undo情報
  #boxのインスタンスリスト取得
  boxinstalist = [sl[0] for sl in sozokulist if sl[0].type=='box']
  #pickleでなければ。tupleやlistのままでは現行のinstanceと同じになる。
  undolist.append(['CHGSTYLEALL','ALL',pi.dumps(boxinstalist,2)])
  #sozokulistのboxインスタンス毎にスタイル読み込んで表示
  for sobj in sozokulist:
    if sobj[0].type == 'box':
      sobj[0].set_style()
  #変更
  set_modified()

#---------------------------------------------------------
#Boxスタイルの既定値の編集
def edit_box_default_style():
  #初期値をグローバル変数にセット
  global sizelist
  global outline_style_list
  global colorlist
  global diag_list
  global boxlookslist
  global undolist
  sizelist = default_box_styles[0:5]
  outline_style_list = default_box_styles[5]
  colorlist = default_box_styles[6]
  diag_list = default_box_styles[7]
  #スタイル入力ダイアログを呼び出し
  styinsta = SozokuDefaultLooks_dialog(canvas,'Boxスタイル既定値の編集')
  #OKで戻ってきたら、結果をdefault_box_styles変数にセット
  if len(styinsta.result):
    oldstyles = set_default_box_styles(styinsta.result)
    #undo情報
    undolist.append(['CHGBOXDEF','ALL',oldstyles])

#-------------------------------------------------------------------
#テキストデータ（複数行）を受けて、全角縦書き表示用の
#文字列（マルチライン）を返す
#複数行の縦並びを揃えるには等倍フォントが必要。
def zentategaki(basestr):
  #前後の空白や空行削除
  #半角→全角（何故か'-'は対象外）
  zen = zenhan.h2z(basestr.strip())

  #数字をつなぐ'ー|一|‐'を'｜'に置き換える。
  #漢数字の一も｜に置き換わるので漢数字の一を使いたい場合は￥一とすること。
  #全体の文字列に対して'ー|一|‐'を'｜'に置き換える
  #何故か半角'-'は置き換えもできない
  reg=u'[ー|一|‐｜-]'
  zen = re.sub(reg,u'｜',zen)
  #文字列に'￥'がある場合、その次の文字を'一'に戻す
  zen = zen.replace('￥｜','一')    

  #改行で分割→リスト
  zenlist = zen.split(u'\n')
  #リストを反転
  zenlist.reverse()
  #リスト要素の最大文字数を調べる
  cmax = 0
  for item in zenlist:
    cmax = len(item) if len(item)>cmax else cmax
  #各要素を最大文字数まで右に全角スペースで埋める（.ljust）
  zenstrlist = []
  for item in zenlist:
    zenstrlist.append(item.ljust(cmax,u'　'))
  #各要素の同順の文字を連結してリスト作成(zip使わず)
  tatelist = []
  for i in range(cmax):
    strsub = ''
    for item in zenstrlist:
      strsub += item[i]
    tatelist.append(strsub)
  #リストの各要素を改行で連結
  return u'\n'.join(tatelist)

#-----------------------------------------------------------------
#日付文字列を受けて縦書用（数字を半角組文字）の文字列を返す
#　非数字は全角縦書、数字は半角組文字に
#日付文字列＝元号99年99月99日、9999年99月99日、S99・99・99
#上記の書式以外は通常の全角縦書を返す
def tatedatestr(datestr):
  #前後の空行などを削除
  sdate = datestr.strip()
  #一旦全角に
  sdate = zenhan.h2z(sdate)
  #数字のみを半角に
  sdate = zenhan.z2h(sdate,2)   #2=digit
  #１文字毎に処理
  ret = ''
  dig = ''
  for i in range(len(sdate)):
    if re.match('^[0-9]',sdate[i]):
      dig += sdate[i]
      #Class Sozoku.dateshow()メソッドの西暦表示簡便化に伴い
      #西暦年を２桁で区切って返すように変更ｰｰｰここから 
      if len(dig)>=2:
        ret += '\n'+dig
        dig = ''
        #--------------------------------- ここまで追加
    elif len(dig):
      ret += '\n'+dig
      ret += '\n'+sdate[i]
      dig = ''
    else:
      ret += '\n'+sdate[i]
  if len(dig):
    ret += '\n'+dig
  ret = ret.strip()
  return ret

#-----------------------------------------------------
## メモテキスト（複数行あり）の文字列を縦書き表示用に置き換える。
## 処理としては、与えられた複数行の文字列を一括全角処理と
## 半角組文字処理を振り分けて結果を返すのみ。
## メモテキストの数字文字は半角組文字処理を原則とする。
## ただし、'##'から次の'##'までは通常の全角処理とする。
## （後の＃＃がない場合は最後まで全角処理）
## split() --> split('\n') 分割は改行だけに限定
def memotatenaka(memostr):
  #改行のみで分割
  #全角→半角（全角空白を無視）改行で分割
  listlines = zenhan.z2h(memostr,3,ignore=('　')).split('\n')
  #各行毎に縦書き処理
  retlst = []
  zenflg = False
  for li in listlines:
    tatestr = ''
    if '##' in li:
      ind = 0
      lmx = len(li)
      while 1:
        fo = li.find('##',ind)
        if fo>ind:
          if not zenflg:
            tatestr += '\n'+ tatedatestr(li[ind:fo])  #組文字処理
            zenflg = True
          else: #zenflg True
            tatestr += '\n'+ zentategaki(li[ind:fo])  #全角処理
            zenflg = False
        elif fo==-1:
          if not zenflg:
            tatestr += '\n'+ tatedatestr(li[ind:])  #組文字処理
          else:
            tatestr += '\n'+ zentategaki(li[ind:])  #全角処理
          break
        else:
          zenflg = False if zenflg else True
        ind = fo + 2
        if ind >=lmx:
          break
      tatestr = tatestr.strip()
    else:
      if zenflg:
        tatestr = zentategaki(li)  #１行　全角処理
      else:
        tatestr = tatedatestr(li) #１行分全部を半角組文字処理
    retlst.append(tatestr)
  return retlst

#--------------------------------------------------------------
#接続ラインクラス                               class Setsuzoku
#--------------------------------------------------------------
class Setsuzoku:
  def __init__(self,linesyu,coords):
    self.type = 'line'
    #絶対id  復元に必要
    self.absid = 0
    #接続種別 'fuhu' or 'oyako'
    self.twoof = linesyu
    #接続先のボックス又はラインのidリスト
    self.frtoids = []
    #婚姻ラインからラインを接続した場合のラインidリスト
    self.lineids = []
    #復元のための座標リスト
    self.linecoords = coords
    #ドラッグ中を示すフラグ
    self.drag_flg = False
    #ライン破線パターン
    self.dash_ptrn = []
    #ライン幅
    self.line_width = 1
    #ライン色
    self.line_color = defcolor
    #ライン描画
    self.mkline()
    #変更
    set_modified()
    #絶対id取得
    self.absid = getabsid()
    #タグバインド設定
    self.set_tag_bind()

  #saveデータをloadした後でキャンバスに再描画する
  def redraw(self):
    #ラインの描画
    self.mkline()
    self.line_iconfig()
    #sozokulistのキャンバスidを更新
    sozokulist[sozoku_idx(self.absid)][1] = self.lineid
    #タグバインド設定
    self.set_tag_bind()
    
  #タグバインド設定
  def set_tag_bind(self):
    #クリックで親子接続
    canvas.tag_bind(self.lineid,'<Button-1>',self.lineclick)
    #削除モードの場合のバインド
    canvas.tag_bind(self.lineid,'<Button-1>',self.delline,'+')
    #標準モード：クリック＆ドラッグ ライン微調整
    canvas.tag_bind(self.lineid,'<Button-1>',self.linepressed,'+')
    canvas.tag_bind(self.lineid,'<Button1-Motion>',self.linedrag)
    canvas.tag_bind(self.lineid,'<ButtonRelease-1>',self.b1release)
    #ライン右クリックでポップアップメニュー
    if cursys == 'Darwin':  #macOS
      canvas.tag_bind(self.lineid,'<ButtonRelease-2>',self.popup)
    else:
      canvas.tag_bind(self.lineid,'<ButtonRelease-3>',self.popup)

  #popupメニュー
  #Lineの右クリックでポップアップメニューを表示
  #ただし、ライン追加モードで２番目のボックス指定を待っているときはpopupしない
  def popup(self,event):
    if mode.get() == 'Lin' and len(line_target)==1:
      return
    #boxmemo追加中の場合はポップアップしない
    if boxmemo_flg:
      return
    global cur_insta
    cur_insta = sozoku_insta(self.absid)
    line_pop_menu.tk_popup(event.x_root,event.y_root,0)

  #ラインスタイルの編集
  def line_style(self):
    global line_style_list
    line_style_list = [self.dash_ptrn,self.line_width,self.line_color]
    #対象のライン色変更
    canvas.itemconfigure(self.lineid,fill=now_style_color)
    #入力ダイアログ
    insta = Setsuzoku_Style_dialog(canvas,'接続ラインスタイル編集')
    #変更されたら反映
    if len(insta.result):
      #Line座標保存
      self.setcoords()
      #undo準備
      global undolist
      undolist.append(['CHG','LINE',pi.dumps(self,2)])
      #変更登録
      self.dash_ptrn,self.line_width,self.line_color = insta.result
      #表示
      self.line_iconfig()
      #変更
      set_modified()
    else:
      #変更ない場合は対象ラインの色を戻す
      canvas.itemconfigure(self.lineid,fill=self.line_color)

  #現在のスタイルを反映する
  def line_iconfig(self):
    canvas.itemconfigure(self.lineid,fill=self.line_color,
                         dash=tuple(self.dash_ptrn),
                         width=self.line_width,
                         activewidth=self.line_width+1)

  #現在の座標を取得して保存
  def setcoords(self):
    self.linecoords = canvas.coords(self.lineid)

  #ライン描画（作成）
  def mkline(self):
    if self.twoof == 'fuhu': #婚姻ライン
      self.line_width = 2
    #既定で夫婦接続のライン幅は２、親子１（＝初期値）
    #初期値はdashパターンなし
    self.lineid = canvas.create_line(*self.linecoords,width=self.line_width,
                                     activewidth=self.line_width+1,
                                     fill=self.line_color,
                                     tags=('sozoku','line'))

  #ラインの編集（微調整）導入部
  def linepressed(self,event):
    if mode.get() != 'Nor':
      return
    self.linecoords = canvas.coords(self.lineid)
    self.x = canvas.canvasx(event.x)
    self.y = canvas.canvasy(event.y)
    #undo準備
    #self.keep = pi.dumps(self,2)
    self.keep = self.linecoords
    #微調整区間の取得と移動可能方向の決定
    mx = int(len(self.linecoords)/2)-1
    for i in range(0,mx):
      x0 = self.linecoords[i*2]
      y0 = self.linecoords[i*2+1]
      x1 = self.linecoords[i*2+2]
      y1 = self.linecoords[i*2+3]
      if x0 == x1:  #縦ライン
        if abs(self.x - x0)<=3: #3ドット以内はOn Line
          if y0 < y1:
            if self.y >= y0 and self.y <= y1:
              #OK i番目の座標ペア、ｘ方向移動
              self.movtarget = ['x',i]
              return
            else:
              continue
          else:   #y0 > y1
            if self.y >= y1 and self.y <= y0:
              #OK i番目の座標ペア、ｘ方向移動
              self.movtarget = ['x',i]
              return
            else:
              continue
        else:
          continue
      else: #y0==y1 横ライン
        if abs(self.y - y0)<=3:
          if x0 < x1:
            if self.x >= x0 and self.x <=x1:
              #OK i番目の座標ペア、Y方向移動
              self.movtarget = ['y',i]
              return
            else:
              continue
          else:   #x0 > x1
            if self.x >= x1 and self.x <= x0:
              #OK i番目の座標ペア、Y方向移動
              self.movtarget = ['y',i]
              return
            else:
              continue
        else:
          continue
    #マウスクリックされた辺が見つからないのは異常
    print("Setsuzoku.linepressed error")
    root.quit()

  #ラインの編集（微調整）実移動
  def linedrag(self,event):
    if mode.get() != 'Nor':
      return
    #drag_flg ON
    self.drag_flg = True
    #self.linecoords, self.movtarget, マウスの移動量を元にラインを再描画
    self.evx = canvas.canvasx(event.x)
    self.evy = canvas.canvasy(event.y)
    tglist = list(self.linecoords)
    if self.movtarget[0]=='x':  #ｘ方向移動
      self.evx = int(self.evx/5)*5  #移動は５ドット単位
      tglist[self.movtarget[1]*2] = self.evx
      tglist[self.movtarget[1]*2+2] = self.evx
    else: #Y方向移動
      self.evy = int(self.evy/5)*5  #移動は５ドット単位
      tglist[self.movtarget[1]*2+1] = self.evy
      tglist[self.movtarget[1]*2+3] = self.evy
    #ラインを再描画
    canvas.coords(self.lineid,*tglist)
    #self.x, self.y を更新
    self.x = self.evx
    self.y = self.evy

  #ドラッグ中のマウスリリースで
  def b1release(self,event):
    if self.drag_flg:
      #undo準備
      global undolist
      undodata = []
      undodata.append([self.absid,self.keep])
      #夫婦ラインの場合は親子ラインも移動
      if self.twoof=='fuhu':
        ret = self.withlines()
        if len(ret):
          undodata.extend(ret)
      #undolist.append(['MOV','LINE',self.keep])
      undolist.append(['MOV','LINE',undodata])
      #変更
      set_modified()
    self.drag_flg = False

  #夫婦ラインの微調整に伴う親子ラインの調整
  #マウスリリース後
  def withlines(self):
    if not len(self.lineids):
      return []
    undodata = []
    for laid in self.lineids:
      #dmy==laid
      linsta,lcid,dmy = get_sozokulist('aid',laid)
      #現在の親子ラインの座標
      lcoords = canvas.coords(lcid)
      #両端座標取得
      end1,end2 = get_linecoords_both_ends(lcoords)
      #Boxの座標取得
      baid = linsta.frtoids[1]  #frtoids[0]は親側
      bcid = get_sozokulist('aid',baid)[1]
      bcoords = canvas.coords(bcid)
      #end1,end2のうちBox側の上辺Y座標と一致しない方が夫婦ラインとの接続点
      #ただし、親子ラインの微調整で夫婦ラインと接続していない可能性あり
      fstcoord = end1 if end2[1]==bcoords[1] else end2
      #Y方向に夫婦ラインがあるかどうか
      fy = get_ycoord_online(fstcoord[0],canvas.coords(self.lineid))
      if fy: #微調整後の夫婦ラインに接続点あり
        if fy==fstcoord[1]: #接続点の移動必要なし
          continue
        else:
          fstcoord[1]=fy
      else: #夫婦ライン上に接続点なし
        #現在の夫婦ライン上に新たな接続点を設ける
        fstcoord = get_fuhuline_cpoint(canvas.coords(self.lineid))
      #親子ラインの再計算
      fst = [LineOBJ,self.absid,fstcoord]
      snd = [KukeiOBJ,baid,bcoords]
      newcoords = calclinecoords('oyako',fst,snd)
      #親子ライン再描画
      canvas.coords(lcid,*newcoords)
      #undo情報
      undodata.append([laid,lcoords])
    return undodata
  
  def delline(self,event):
    if mode.get() != 'Del':
      return
    res = self.delline_sub()
    #undo情報
    global undolist
    undolist.append(['DEL','LINE',res])
    #変更
    set_modified()

  def deleteme(self):
    return self.delline_sub()

  def delline_sub(self):
    #undo準備
    undodata = []
    #婚姻ラインを削除する前に親子ラインを削除する   
    if len(self.lineids):
      instalist = []
      for lid in self.lineids:
        instalist.append(sozokulist[sozoku_idx(lid)][0])
      #ループを分けないと親子ラインを削除する際に
      #lineidsやsozokulist自体が書き換えられるから
      for ins in instalist:
        res = ins.delline_sub()
        #undo情報
        if not undo_flg:
          undodata.extend(res)
    #接続先のボックスやラインのlineids[]リストから自身のidを削除
    for i in range(0,2):
      idx = sozoku_idx(self.frtoids[i])
      insta = sozokulist[idx][0]
      insta.dellineid(self.absid)
    #sozokulist[]から自身を削除
    del sozokulist[sozoku_idx(self.absid)]
    #undo準備
    if not undo_flg:
      self.linecoords = canvas.coords(self.lineid)
      undodata.append(pi.dumps(self,2))
    #実際のラインを削除
    canvas.delete(self.lineid)
    return undodata
  
  #self.lineidsに接続ラインidを追加
  def addlineid(self,lid):
    self.lineids.append(lid)

  #self.lineidsから指定されたラインidを削除
  def dellineid(self,lid):
    self.lineids.remove(lid)

  #self.frtoidsに接続先のボックス又はラインのidを追加
  def addboxid(self,blid):
    self.frtoids.append(blid)

  #self.frtoidsから指定されたボックス又はラインのidを削除
  def delboxid(self,blid):
    self.frtoids.remove(blid)

  def lineclick(self,event):
    if mode.get() != 'Lin':
      return
    if self.twoof != 'fuhu':
      return
    if len(line_target)==1:
      if line_target[0][0]==LineOBJ:
        #すでにラインが登録されている
        return
    #クリック位置付近の中央座標（接続座標）を求める
    lx = canvas.canvasx(event.x)
    lx = int((lx-xmargin)/xttl)*xttl+xmargin+xsize+xspace/2
    ly = canvas.canvasy(event.y)
    ly = int(ly/10)*10 if ly%10<=3 else (int(ly/10)+1)*10
    #line_targetに追加
    line_target.append([LineOBJ,self.absid,[lx,ly]])
    #１つ目がラインだったらラインの色を変更
    if len(line_target)==1:
      canvas.itemconfigure(self.lineid,fill=now_edit_color)
    #配列に２つ入ったらライン描画
    if len(line_target)==2:
      draw_line()
#-------------------------------------------------class Setsuzoku  end

#---------------------------------------------------------
#婚姻ライン又は親子ラインの選択ダイアログ     class KonOyaDlg
#---------------------------------------------------------
class KonOyaDlg(simpledialog.Dialog):
  def body(self,master):
    self.okbtn = 0
    self.res = StringVar()
    self.res.set('fuhu')
    Radiobutton(master, text="婚姻ライン", variable=self.res,
                value='fuhu').grid(row=0)
    Radiobutton(master, text="親子ライン", variable=self.res,
                value='oyako').grid(row=1)

  def apply(self):
    self.okbtn = 1

#---------------------------------------------------------
#接続ラインのスタイル編集ダイアログ class Setsuzoku_Style_dialog
#---------------------------------------------------------
class Setsuzoku_Style_dialog(simpledialog.Dialog):
  def body(self,master):
    # line_style_list = [[dash_ptrn],width,color]
    self.result = []  #承継元のアトリビュートを上書き
    #入力値検証関数ラッパー
    self.wrap_is_valid = master.register(self.is_valid)
    self.wrap_invalid = master.register(self.invalid)
    self.wrap_is_valid_dash = master.register(self.is_valid_dash)
    self.wrap_invalid_dash = master.register(self.invalid_dash)
    self.parent = master
    
    #破線パターン
    ptnstr = ','.join([str(x) for x in line_style_list[0]])
    self.dash_entry = self.mk_entry('破線パターン',ptnstr,0,0,7,master)
    #線幅
    self.width_entry = self.mk_entry('線幅',line_style_list[1],0,2,2,master)
    #カラー
    self.colorstr = line_style_list[2]
    self.linebtn = Button(master,text=self.colorstr, fg=self.colorstr,width=8,
                          command=lambda:self.getcolor(self.colorstr,'接続線',master))
    self.linebtn.grid(row=0,column=4)
    #破線パターン説明
    Label(master,text='※draw_dot数,stip_dot数,・・',
          font=labelfontmini).grid(row=1,columnspan=3,sticky=W)
    self.dash_entry.focus_set()
    return self.dash_entry # initial focus

  def mk_entry(self,ttl,orgstr,rnum,cnum,wth,master):
    Label(master,text=ttl,font=labelfont).grid(row=rnum,column=cnum)
    if ttl=='線幅':
      entry = Entry(master,width=wth,font=entryfont,
                    validate='all',
                    validatecommand=(self.wrap_is_valid,'%P','%V','%W'),
                    invalidcommand=(self.wrap_invalid,'%W'))
    else:
      entry = Entry(master,width=wth,font=entryfont,
                    validate='all',
                    validatecommand=(self.wrap_is_valid_dash,'%P','%V','%W'),
                    invalidcommand=(self.wrap_invalid_dash,'%W'))
    entry.delete(0,END)
    entry.insert(0,orgstr)
    entry.grid(row=rnum,column=cnum+1,padx=2,pady=2,sticky=W)
    return entry

  def ok(self, event=None):
    if not self.validate():
      self.initial_focus.focus_set() # put focus back
      return
    self.withdraw()
    self.update_idletasks()

    try:
      self.apply()
    finally:
      self.cancel()

  def validate(self):
    den = self.dash_entry.get().strip()
    wen = self.width_entry.get().strip()
    if not re.match('^[1-9][0-9]??$',wen):
      messagebox.showerror('入力エラー','1〜99までの値を半角で入力してください')
      return False
    if len(den):
      if not re.match('^([1-9],)+[1-9]$',den):
        messagebox.showerror('入力エラー',
                             '描画ドット数と空白ドット数を半角カンマ区切りで')
        return False
    return True

  def is_valid(self,value,reason,wd):
    if reason=='focusout':
      if re.match('^[1-9][0-9]??$',value):
        return True
      else:
        return False
    else:
      return True

  def invalid(self,wd):
    messagebox.showerror('入力エラー','1〜99までの値を半角入力')
    #self.parent.nametowidget(wd).focus_set()
    self.initial_focus.focus_set()

  def is_valid_dash(self,value,reason,wd):
    if reason=='focusout':
      if re.match('^([1-9],)+[1-9]$',value):
        return True
      else:
        if not len(value):  #入力なしも認める
          return True
        else:
          return False
    else:
      return True

  def invalid_dash(self,wd):
    messagebox.showerror('入力エラー',
                       '描画ドット数と空白ドット数を半角カンマ区切りで')
    #self.parent.nametowidget(wd).focus_set()
    self.initial_focus.focus_set()

  def getcolor(self,colorstr,ttl,master):
    rescolor = colorchooser.askcolor(parent=master,initialcolor=colorstr,
                                     title=ttl+'：カラー選択')
    if not rescolor[0]==None:
      self.colorstr = rescolor[1]
      self.linebtn.configure(text=self.colorstr,fg=self.colorstr,
                             command=lambda:self.getcolor(self.colorstr,ttl,master))

  def apply(self):
    daptn = self.dash_entry.get()
    if len(daptn):
      retptn=[int(x) for x in daptn.split(',')]
      #ドット数0は１に置き換える
      retptn=[1 if x==0 else x for x in retptn]
    else:
      retptn=[]
    wd = self.width_entry.get()
    if len(wd):
      retwd = int(wd)
      retwd = 1 if retwd==0 else retwd
    else:
      retwd = 1
    self.result = [retptn,retwd,self.colorstr]

  def buttonbox(self):  #エンターキーのバインドを外した
    box = Frame(self)
    w = Button(box, text="OK", width=10, command=self.ok)
    w.pack(side=LEFT, padx=5, pady=5)
    w = Button(box, text="Cancel", width=10, command=self.cancel)
    w.pack(side=LEFT, padx=5, pady=5)
    #self.bind("<Return>", self.ok)
    self.bind("<Escape>", self.cancel)
    box.pack()
#----------------------------------class Setsuzoku_Style_dialog   end

#---------------------------------------------------------
#任意テキストクラス                          class MemoText
#---------------------------------------------------------
class MemoText:
  def __init__(self,mx,my):
    self.type = 'memo'
    self.coords = [mx,my]
    self.empty = True
    self.displayed = False
    self.drag_flg = False
    self.absid = 0
    #メモは１字毎にcanvas-idが作成されるので個々のidは登録しない
    #self.memoid = 0
    self.is_tate = True
    self.memo = ''
    self.tatememo = ''
    self.memo_size = size_me
    self.memo_bold = 0
    self.memo_italic = 0
    self.memofont = ""
    self.set_font_size_style()
    self.memo_color = defcolor
    if boxmemo_flg:   #box連動メモの場合
      self.boxid = cur_insta.absid  #連動するBoxの絶対id
    else:
      self.boxid = None
    #めも編集
    self.memo_edit()
    if not self.empty:
      #絶対id取得
      self.absid = getabsid()
      self.memo_show()
      self.set_tag_bind()
      #boxmemo対応
      if boxmemo_flg:
        if hasattr(cur_insta,'memoids'):
          cur_insta.memoids.append(self.absid)
        else:
          cur_insta.memoids=[self.absid]

  #表示用フォントサイズ、スタイルの設定
  def set_font_size_style(self):
    dispfont = []
    dispfont.append(tatefont)
    dispfont.append(self.memo_size)
    if self.memo_bold:
      dispfont.append('bold')
    if self.memo_italic:
      dispfont.append('italic')
    self.memofont = tuple(dispfont)

  #タグバインドの設定
  def set_tag_bind(self):
    #マウスが上に来た
    canvas.tag_bind(str(self.absid)+'memo','<Enter>',self.enter)
    #マウスが通りすぎた
    canvas.tag_bind(str(self.absid)+'memo','<Leave>',self.leave)
    #標準モード：移動、削除モードで削除
    canvas.tag_bind(str(self.absid)+'memo','<Button-1>',self.pressed)
    canvas.tag_bind(str(self.absid)+'memo','<Button1-Motion>',self.dragging)
    canvas.tag_bind(str(self.absid)+'memo','<ButtonRelease-1>',self.b1release)
    #標準モード：ダブルクリックで編集
    canvas.tag_bind(str(self.absid)+'memo','<Double-Button-1>',
                    self.memo_doubleclick)
    #メモ上、右クリックでポップアップメニュー
    if cursys == 'Darwin':  #macOS
      canvas.tag_bind(str(self.absid)+'memo','<ButtonRelease-2>',self.memopop)
    else:
      canvas.tag_bind(str(self.absid)+'memo','<ButtonRelease-3>',self.memopop)

  #popupメニュー
  #Memo上で右クリックでポップアップメニュー
  #ただし、ライン追加モードで２番目のボックス指定を待っているときはpopupしない
  def memopop(self,event):
    if mode.get() == 'Lin' and len(line_target)==1:
      return
    #boxmemo追加中の場合はポップアップしない
    if boxmemo_flg:
      return
    #連動の有無でメニュー表示を変更
    if hasattr(self,'boxid'):
      if self.boxid:
        memo_pop_menu.entryconfig(memopop_iboxmemo,label='通常メモに変更')
      else:
        memo_pop_menu.entryconfig(memopop_iboxmemo,label='連動メモに変更')
    else:
      #アトリビュートを作成
      self.boxid = None
      memo_pop_menu.entryconfig(memopop_iboxmemo,label='連動メモに変更')
    #標準モード以外では連動メモメニューは非選択
    if mode.get() != 'Nor':
      memo_pop_menu.entryconfig(memopop_iboxmemo,state='disabled')
    else:
      memo_pop_menu.entryconfig(memopop_iboxmemo,state='normal')
    
    global cur_insta
    cur_insta = sozoku_insta(self.absid)
    memo_pop_menu.tk_popup(event.x_root,event.y_root,0)

  #フォントサイズ・スタイル
  def fontsize(self):
    #対象メモの色を変える
    canvas.itemconfigure(str(self.absid)+'memo',fill='blue')
    #外部変数に現在の値を渡して入力ダイアログ呼び出し
    global sizelist
    sizelist = [self.memo_size,self.memo_bold,self.memo_italic,self.memo_color]
    insta = MemoFontSize_dialog(root,'フォントサイズ・スタイル設定')
    if len(insta.result):
      #undo準備
      if [self.memo_size,self.memo_bold,self.memo_italic,self.memo_color] != \
         insta.result:
        global undolist
        undolist.append(['CHG','MEMO',pi.dumps(self,2)])
        #変更
        set_modified()
      self.memo_size,self.memo_bold,self.memo_italic,self.memo_color = \
          insta.result
      #表示用フォントサイズ、スタイル文字列設定
      self.set_font_size_style()
      #表示
      if self.displayed:
        self.memo_show()
    #メモ色復帰
    canvas.itemconfigure(str(self.absid)+'memo',fill=self.memo_color)

  #表示フォント変更で再表示
  def show_chg_font(self):
    #表示用フォントサイズ、スタイル文字列設定
    self.set_font_size_style()
    #表示
    self.memo_show()

  #メモ編集
  def memo_edit(self):
    #入力ダイアログ呼び出し
    global memowk
    memowk = [self.memo,self.is_tate]
    memoinsta = Memo_dialog(canvas,"メモ入力")
    #undo準備
    if len(memoinsta.result):
      if memoinsta.result[0] != memowk[0] or memoinsta.result[2] != memowk[1]:
        global undolist
        if len(memoinsta.result[0])==0:  #メモ内容が空の場合は削除されるから
          undolist.append(['DEL','MEMO',pi.dumps(self,2)])
          #変更
          set_modified()
        elif len(memowk[0]):  #編集前が''なら最初の呼び出しなのでCHGではない
          undolist.append(['CHG','MEMO',pi.dumps(self,2)])
          #変更
          set_modified()
      self.memo, self.tatememo, self.is_tate = memoinsta.result
      if len(self.memo)==0:
        self.empty = True
        if self.absid:
          self.deleteme()
      else:
        self.empty = False

  #メモ表示
  def memo_show(self,loadjob=False):
    if not loadjob:
      #現在の表示を削除
      if self.displayed:
        canvas.delete(str(self.absid)+'memo')
    #表示
    #横書きの場合はself.memoから'##'又は'＃＃'を削除して表示
    #横書きは制御文字を除き原則入力文字をそのまま表示
    #self.tatememoはマルチライン（文字毎に改行）の配列
    ##マルチラインの出力は可能だが、svg出力がマルチラインに未対応のため
    ##１文字単位に出力
    x = self.coords[0]
    y = self.coords[1]
    fh = int(self.memo_size * dpi / ppi)
    if self.is_tate:
      for tlt in self.tatememo:
        y = self.coords[1]
        for wrd in tlt.split('\n'):
          canvas.create_text(x,y,text=wrd,font=self.memofont,anchor='n',
                             fill=self.memo_color,
                             tags=('sozoku','memo',str(self.absid)+'memo'))
          y += fh
        x -= fh+1
    else: #横書き
      tl = self.memo.split('\n')
      for tlt in tl:
        canvas.create_text(x,y,text=re.sub('＃＃|##','',tlt),
                           font=self.memofont,anchor='nw',
                           fill=self.memo_color,
                           tags=('sozoku','memo',str(self.absid)+'memo'))
        y += fh
    #boxmemoの場合
    if hasattr(self,'boxid'):
      if self.boxid:
        canvas.addtag_withtag(str(self.boxid)+'boxmemo',
                              str(self.absid)+'memo')
    #表示済み
    self.displayed = True

  #削除処理
  def deleteme(self):
    undodata = ''
    #undo準備
    if not undo_flg:
      self.coords = canvas.coords(str(self.absid)+'memo')
      undodata = pi.dumps(self,2)
    #boxmemoの場合：box側のmemoidsアトリビュート調整
    if self.boxid:
      #memoids[]にself.absidがなければエラーになるが…
      sozoku_insta(self.boxid).memoids.remove(self.absid)
    #テキスト表示削除
    canvas.delete(str(self.absid)+'memo')
    #インスタンスリストの登録削除
    global sozokulist
    del sozokulist[sozoku_idx(self.absid)]
    self.displayed = False
    self.empty = True
    #変更
    return undodata

  #再描画（ロード後に呼ばれる）
  def redraw(self):
    self.memo_show(True)
    self.set_tag_bind()

  #マウスが来たら色変更に
  def enter(self,event):
    canvas.itemconfigure(str(self.absid)+'memo',fill=now_edit_color)

  #マウスが離れたら黒に
  def leave(self,event):
    canvas.itemconfigure(str(self.absid)+'memo',fill=self.memo_color)

  #移動又は削除
  def pressed(self,event):
    #標準モード：移動（準備）
    if mode.get() == 'Nor':
      self.coords = canvas.coords(str(self.absid)+'memo')
      self.keep = pi.dumps(self,2)
      #最初のマウス座標
      self.x = canvas.canvasx(event.x)
      self.y = canvas.canvasy(event.y)
    #削除モード
    elif mode.get() == 'Del':
      res = self.deleteme()
      global undolist
      undolist.append(['DEL','MEMO',res])
      #変更
      set_modified()

  #移動
  def dragging(self,event):
    self.drag_flg = True
    self.evx = canvas.canvasx(event.x)
    self.evy = canvas.canvasy(event.y)
    #標準モード以外は無視
    if mode.get() != 'Nor':
      return
    self.xmov = self.evx - self.x
    self.ymov = self.evy - self.y
    #undo準備
    canvas.move(str(self.absid)+'memo',self.xmov,self.ymov)
    self.x += self.xmov
    self.y += self.ymov
    #メモの座標を保存するが、その位置が心配
    self.coords = canvas.coords(str(self.absid)+'memo')

  #移動の最後でリリースしたとき
  def b1release(self,event):
    if mode.get() != 'Nor':
      return
    if self.drag_flg:
      #undo準備
      global undolist
      undolist.append(['MOV','MEMO',self.keep])
      #変更
      set_modified()
    self.drag_flg = False

  #ダブルクリックで編集
  #ただし、メモテキスト追加モードでは編集しない
  #  ダブルクリックとクリック、両方のEVが発生するから
  def memo_doubleclick(self,event):
    if mode.get()=='Tex':
      return
    self.memo_dblclk_sub()
    
  #memo_doubleclickの下請け
  def memo_dblclk_sub(self):
    self.memo_edit()
    if not self.empty:
      #一旦消して再描画
      canvas.delete(str(self.absid)+'memo')
      self.memo_show()
      self.empty = False

  #現在の座標を取得して保存
  #ただし、座標はメモの先頭文字部分のみ？
  def setcoords(self):
    self.coords = canvas.coords(str(self.absid)+'memo')

#------------------------------------------ class MemoText  end

#---------------------------------------------------------
#メモテキスト入力ダイアログ                class Memo_dialog
#---------------------------------------------------------
class Memo_dialog(simpledialog.Dialog):
  def body(self,master):
    self.result = []  #承継元のアトリビュートを上書き
    #IME制御
    self.imesetted = False
    #メモ
    self.text_memo = self.mk_text_entry("メモテキスト",memowk[0],0,master)
    #縦書、横書選択ラジオボタン
    self.radiores = StringVar()
    if memowk[1]:
      self.radiores.set('tate')
    else:
      self.radiores.set('yoko')
    Radiobutton(master, text="縦 書", variable=self.radiores,
                value='tate').grid(row=3)
    Radiobutton(master, text="横 書", variable=self.radiores,
                value='yoko').grid(row=4)
    self.text_memo.focus_set()
    return self.text_memo # initial focus

  def mk_text_entry(self,ttl,strdata,num,master):
    Label(master,text=ttl,font=labelfont).grid(row=num,rowspan=3)
    text_entry = Text(master,width=30,height=3,font=entryfont)
    text_entry.delete(1.0,END)
    text_entry.insert(END,strdata)
    text_entry.grid(row=num,rowspan=3,column=1,columnspan=2)
    #IME制御
    #if not cursys == 'Windows':
    if chkres['xte']:
      text_entry.bind('<FocusIn>',self.focusin)
    #Tab制御
    text_entry.bind('<Tab>',self.focustonext)
    return text_entry

  #IME制御
  def focusin(self,event):
    if not self.imesetted:
      control_space_sequence = \
                'keydown Control_L\nkey Space\nkeyup Control_L\n'
      control_space_sequence = control_space_sequence.encode('utf-8')
      p = Popen(['xte'], stdin=PIPE)
      p.communicate(input=control_space_sequence)
      #ｐは閉じる必要がない？
      self.imesetted = True
    else:
      return

  #テキストエントリー内のタブキー制御
  def focustonext(self,event):
    event.widget.tk_focusNext().focus()
    return("break")

  def apply(self):
    memostr = self.text_memo.get(1.0,END)
    memostr = memostr.strip()   #空行削除
    #全角縦書に変換
    #tatememo = zentategaki(memostr)
    #半角数字の組文字処理
    tatememo = memotatenaka(memostr)
    tateflg = True if self.radiores.get()=='tate' else False
    self.result = [memostr,tatememo,tateflg]

  def buttonbox(self):  #入力中に改行する必要があるのでエンターキーのバインドを外した
    box = Frame(self)
    w = Button(box, text="OK", width=10, command=self.ok)
    w.pack(side=LEFT, padx=5, pady=5)
    w = Button(box, text="Cancel", width=10, command=self.cancel)
    w.pack(side=LEFT, padx=5, pady=5)
    #self.bind("<Return>", self.ok)
    self.bind("<Escape>", self.cancel)
    box.pack()
#----------------------------------------  class Memo_dialog  end

#---------------------------------------------------------
#メモスタイル入力                 class MemoFontSize dialog
#---------------------------------------------------------
class MemoFontSize_dialog(simpledialog.Dialog):
  def body(self,master):
    #sizelist= [memo_size,memo_bold,memo_italic]
    self.result = []  #承継元のアトリビュートを上書き
    Label(master,text='項　目',font=labelfont).grid(row=0)
    Label(master,text='サイズ',font=labelfont).grid(row=0,column=1)
    Label(master,text='スタイル',font=labelfont).grid(row=0,column=2,columnspan=2)
    Label(master,text='カラー',font=labelfont).grid(row=0,column=4)
    #入力値検証関数ラッパー
    self.wrap_is_valid = master.register(self.is_valid)
    self.wrap_invalid = master.register(self.invalid)
    self.parent = master
    
    #メモ
    self.chk_memo_bold = IntVar()
    self.chk_memo_ital = IntVar()
    self.memo_color_str = sizelist[3]
    self.memo_entry,self.memobtn = self.mk_entry('メモ文字列',sizelist,1,
                               self.chk_memo_bold,self.chk_memo_ital,master)
    self.memo_entry.focus_set()
    return self.memo_entry # initial focus

  def mk_entry(self,ttl,orglist,num,boldvar,italvar,master):
    Label(master,text=ttl,font=labelfont).grid(row=num)
    entry = Entry(master,width=2,font=entryfont,
                  validate='all',
                  validatecommand=(self.wrap_is_valid,'%P','%V','%W'),
                  invalidcommand=(self.wrap_invalid,'%W'))
    entry.delete(0,END)
    entry.insert(0,orglist[0])
    entry.grid(row=num,column=1,padx=2,pady=2)
    boldvar.set(orglist[1])
    italvar.set(orglist[2])
    d=Checkbutton(master, text="太字", variable=boldvar)
    d.grid(row=num,column=2)
    e=Checkbutton(master, text="斜体", variable=italvar)
    e.grid(row=num,column=3)
    button = Button(master,text=orglist[3], fg=orglist[3], width=8,
                    command=lambda:self.getcolor(orglist[3],'メモ',master))
    button.grid(row=num,column=4)
    return [entry,button]

  def ok(self, event=None):
    if not self.validate():
      self.initial_focus.focus_set() # put focus back
      return
    self.withdraw()
    self.update_idletasks()

    try:
      self.apply()
    finally:
      self.cancel()

  def validate(self):
    def rematch(ent):
      if not re.match('^[1-9][0-9]??$',ent):
        messagebox.showerror('入力エラー','1〜99までの値を半角で入力してください')
        return False
      else:
        return True
    e1 = self.memo_entry.get().strip()
    if not rematch(e1):
      return False
    return True


  def is_valid(self,value,reason,wd):
    if reason=='focusout':
      if re.match('^[1-9][0-9]??$',value):
        return True
      else:
        return False
    else:
      return True

  def invalid(self,wd):
    messagebox.showerror('入力エラー','1〜99までの値を半角で入力してください')
    self.parent.nametowidget(wd).focus_set()

  def getcolor(self,colorstr,ttl,master):
    rescolor = colorchooser.askcolor(parent=master,initialcolor=colorstr,
                                     title=ttl+'：カラー選択')
    if not rescolor[0]==None:
      self.memo_color_str = rescolor[1]
      #ボタン表示、色変更
      self.memobtn.configure(text=rescolor[1],fg=rescolor[1],
                      command=lambda:self.getcolor(rescolor[1],ttl,master))

  def apply(self):
    self.result = [int(self.memo_entry.get()),self.chk_memo_bold.get(),
                    self.chk_memo_ital.get(),self.memo_color_str]

  def buttonbox(self):  #入力中に改行する必要があるのでエンターキーのバインドを外した
    box = Frame(self)
    w = Button(box, text="OK", width=10, command=self.ok)
    w.pack(side=LEFT, padx=5, pady=5)
    w = Button(box, text="Cancel", width=10, command=self.cancel)
    w.pack(side=LEFT, padx=5, pady=5)
    #self.bind("<Return>", self.ok)
    self.bind("<Escape>", self.cancel)
    box.pack()
#----------------------------------------------- class MemoFontSize dialog end

#--------------------------------------------------------------
#キーイベント処理
#ライン追加モードで１つ目が選択されているときESCで選択解除
#boxmemo追加中、ESCで追加中止
def key_ev(event):
  if mode.get()=='Lin' and len(line_target)==1:
    line_cancel()
  if boxmemo_flg:
    boxmemo_func()

#--------------------------------------------------------------
#ライン追加時、１つ目選択済みのときのキャンセル処理
def line_cancel():
  #１つ目の矩形の背景色（又はラインの色）を戻す
  tgid = sozoku_canvasid(line_target[0][1])
  insta = sozoku_insta(line_target[0][1])
  if line_target[0][0]==KukeiOBJ:
    canvas.itemconfigure(sozoku_canvasid(line_target[0][1]),fill=insta.bg_color)
  else: #ライン
    canvas.itemconfigure(sozoku_canvasid(line_target[0][1]),fill=insta.line_color)
  #配列クリア
  if len(line_target)==2:
    line_target.remove(line_target[1])
  line_target.remove(line_target[0])

#--------------------------------------------------------------
#ライン描画（作成）
def draw_line():
  #配列の２番目がラインの場合
  #婚姻、親子関係の選択
  fst,snd = line_target
  #夫婦ラインが後になっている場合は修正
  if fst[0]==KukeiOBJ and snd[0]==LineOBJ:
    fst,snd = snd,fst
  #矩形同士の場合はユーザーに種別を確認
  if fst[0]==KukeiOBJ and snd[0]==KukeiOBJ:
    kod = KonOyaDlg(root)
    if kod.okbtn:
      linesyu = kod.res.get()
    else:
      #キャンセルの処理
      line_cancel()     
      return
  else:
    linesyu = 'oyako'
  #ライン座標計算
  linecoords = calclinecoords(linesyu,fst,snd)
  #ライン生成
  insta=Setsuzoku(linesyu,linecoords)
  #sozokulistに追加
  sozokulist.append([insta,insta.lineid,insta.absid])
  #ラインのidを接続先のアトリビュートに保存
  setlineidtobox(insta.absid)
  #接続先のbox or lineのidをラインのアトリビュートに保存
  setboxidtoline(insta)
  #描画後に１つ目の矩形の背景色（又はラインの色）を戻す
  line_cancel()
  #undo準備
  global undolist
  undolist.append(['ADD','LINE',pi.dumps(insta,2)])
  #変更
  set_modified()

#--------------------------------------------------------------
#ラインのアトリビュートに接続先のボックス又はラインの絶対idをセット
def setboxidtoline(insta):
  for i in range(0,2):
    insta.addboxid(line_target[i][1])

#--------------------------------------------------------------
#line_targetを基にラインidを接続先ボックス又はラインのlineidsリストに追加
def setlineidtobox(lid):
  for i in range(0,2):
    insta = sozoku_insta(line_target[i][1])
    insta.addlineid(lid)

#--------------------------------------------------------------
#ラインの各座標を算出して配列にして返す
#fst,snd->[ KukeiOBJ or LineOBJ, absid, [coords] ]
def calclinecoords(linesyu,fst,snd):
  #算出したライン座標が角屈折点で水平・垂直に折れ曲がるよう調整する
  def check_coords(coords):
    if len(coords)<=4:
      return coords
    retcoords = []
    for i in range(0,len(coords),2):
      if i==0:
        x0,y0 = coords[i],coords[i+1]
        x1,y1 = coords[i+2],coords[i+3]
        if x0==x1 and y0!=y1:
          next_tate_flg = False
        elif x0!=x1 and y0==y1:
          next_tate_flg = True
        retcoords.extend([x0,y0])
      else:
        if i>=len(coords)-2:
          retcoords.extend([coords[i],coords[i+1]])
          break
        x0,y0 = coords[i],coords[i+1]
        x1,y1 = coords[i+2],coords[i+3]
        if next_tate_flg:
          if x0==x1 and y0!=y1:
            retcoords.extend([x0,y0])
            next_tate_flg = False
        else:
          if x0!=x1 and y0==y1:
            retcoords.extend([x0,y0])
            next_tate_flg = True
    return retcoords

  #婚姻接続ライン------------
  if linesyu=='fuhu':
    if fst[2][0] < snd[2][0]:
      fst,snd = snd,fst  #fstが右側の矩形とする
    if fst[2][1]==snd[2][1]:  #矩形座標は同じ高さ
      if abs(fst[2][0]-snd[2][0]) <= xttl:  #隣接している
        return [fst[2][0],fst[2][1]+norkon_ys,
                snd[2][2],snd[2][1]+norkon_ys ]
      else:   #離れている（ｘ方向）
        x0 = fst[2][0]
        y0 = fst[2][1]+saikon_ys
        x1 = x0 - saikon_xs
        y1 = y0
        x2 = x1
        y2 = y1 - saikon_ys * 2
        x3 = snd[2][2] + saikon_xs
        y3 = y2
        x4 = x3
        y4 = y3 + saikon_ys * 2
        x5 = snd[2][2]
        y5 = y4
        return [x0,y0,x1,y1,x2,y2,x3,y3,x4,y4,x5,y5]
    else:   #矩形座標は異なる高さ(どちらが高くてもスクリプトは同じ)
      x0 = fst[2][0]
      y0 = fst[2][1]+saikon_ys
      x1 = x0 - saikon_xs
      y1 = y0
      if abs(fst[2][0]-snd[2][0]) <= xttl:  #ｘ方向は隣接
        if fst[2][0]==snd[2][0]: #まずないけど、真上下の位置にある場合
          x2 = x1
          y2 = snd[2][1] - saikon_ys
          x3 = snd[2][2] + saikon_xs
          y3 = y2
          x4 = x3
          y4 = snd[2][1] + saikon_ys
          x5 = snd[2][2]
          y5 = y4
          return [x0,y0,x1,y1,x2,y2,x3,y3,x4,y4,x5,y5]
        else:
          x2 = x1
          y2 = snd[2][1] + saikon_ys
          x3 = snd[2][2]
          y3 = y2
          return [x0,y0,x1,y1,x2,y2,x3,y3]
      else:  #ｘ方向も離れている
        x2 = x1
        y2 = snd[2][1] - saikon_ys
        x3 = snd[2][2] + saikon_xs
        y3 = y2
        x4 = x3
        y4 = snd[2][1] + saikon_ys
        x5 = snd[2][2]
        y5 = y4
        return [x0,y0,x1,y1,x2,y2,x3,y3,x4,y4,x5,y5]

  #親子接続ライン------------------
  else:
    #必ずfstが親でsndが子
    #婚姻ラインからの接続
    if fst[0]==LineOBJ:
      x0 = fst[2][0]
      y0 = fst[2][1]
      x1 = x0
      if y0 < ymargin:
        y1 = int((y0-ymargin)/yttl)*yttl+ymargin+ysize+yspace/2
      else:
        y1 = (int((y0-ymargin)/yttl)*yttl+ymargin+ysize+yspace/2
            if (y0-ymargin)%yttl < ysize else
            (int((y0-ymargin)/yttl)+1)*yttl+ymargin+ysize+yspace/2)
      #親が上にある
      if y1 < snd[2][1]:
        #すでに接続可能位置にいる
        if y1 == snd[2][1]-yspace/2:
          x2 = snd[2][0]+xsize/2
          y2 = y1
          x3 = x2
          y3 = snd[2][1]
          #return [x0,y0,x1,y1,x2,y2,x3,y3]
          return check_coords([x0,y0,x1,y1,x2,y2,x3,y3])
        else:
          x2 = x1
          y2 = snd[2][1]-yspace/2
          x3 = snd[2][0]+xsize/2
          y3 = y2
          x4 = x3
          y4 = snd[2][1]
          #return [x0,y0,x1,y1,x2,y2,x3,y3,x4,y4]
          return check_coords([x0,y0,x1,y1,x2,y2,x3,y3,x4,y4])
      #親が下にある
      else:
        if fst[2][0] >= snd[2][0]:   #婚姻ライン接続点より左に矩形あり
          x2 = snd[2][2]+xspace/2
        else:  #婚姻ライン接続点より右に矩形あり
          x2 = snd[2][0]-xspace/2
        y2 = y1
        x3 = x2
        y3 = snd[2][1]-yspace/2
        x4 = snd[2][0]+xsize/2
        y4 = y3
        x5 = x4
        y5 = snd[2][1]
        #return [x0,y0,x1,y1,x2,y2,x3,y3,x4,y4,x5,y5]
        return check_coords([x0,y0,x1,y1,x2,y2,x3,y3,x4,y4,x5,y5])
    #矩形同士の接続（養子、認知、片親など）
    else:
      if fst[2][0] > snd[2][0]:  #親より左に子の矩形
        x0 = fst[2][0]+yoshi_xs
      else:  #親より右に子の矩形
        x0 = fst[2][2]-yoshi_xs
      y0 = fst[2][3]
      x1 = x0
      y1 = fst[2][3]+yoshi_ys
      #すぐ下の段に子の矩形
      if fst[2][3]+yspace == snd[2][1]:
        if fst[2][0] > snd[2][0]:  #親より左に子の矩形
          x2 = snd[2][2]-yoshi_xs
        else:  #親より右に子の矩形
          x2 = snd[2][0]+yoshi_xs
        y2 = y1
        x3 = x2
        y3 = snd[2][1]
        #return [x0,y0,x1,y1,x2,y2,x3,y3]
        return check_coords([x0,y0,x1,y1,x2,y2,x3,y3])
      else:   #子は他の段にある
        if fst[2][0] > snd[2][0]:  #親より左に子の矩形
          x2 = snd[2][2]+yoshi_xs
        else:  #親より右に子の矩形
          x2 = snd[2][0]-yoshi_xs
        y2 = y1
        x3 = x2
        y3 = snd[2][1]-yoshi_ys
        if fst[2][0] > snd[2][0]:  #親より左に子の矩形
          x4 = snd[2][2]-yoshi_xs
        else:  #親より右に子の矩形
          x4 = snd[2][0]+yoshi_xs
        y4 = y3
        x5 = x4
        y5 = snd[2][1]
        #return [x0,y0,x1,y1,x2,y2,x3,y3,x4,y4,x5,y5]
        return check_coords([x0,y0,x1,y1,x2,y2,x3,y3,x4,y4,x5,y5])

#--------------------------------------------------------------
#変更されたかどうか
def is_modified():
  return True if modified else False

#--------------------------------------------------------------
#変更された
def set_modified():
  global modified
  modified = True

#--------------------------------------------------------------
#保存、初期化した
def clear_modified():
  global modified
  modified = False

#--------------------------------------------------------------
#絶対id採番
def getabsid():
  global absidnow
  ret = absidnow
  absidnow += 1
  return ret

#--------------------------------------------------------------
#マウスクリックの座標を基に矩形座標を返す
def sozoku_zahyo(x,y):
  #マージン内をクリックした場合
  if x<=xmargin or x>=xmax-xmargin or y<=ymargin or y>=ymax-ymargin:
    return []
  #ｘ，ｙを基に所定間隔の矩形位置を仮設定
  x0 = int((x-xmargin)/xttl)*xttl+xmargin if (x-xmargin)%xttl <= xsize else 0
  y0 = int((y-ymargin)/yttl)*yttl+ymargin if (y-ymargin)%yttl <= ysize else 0
  if x0==0 or y0==0:
    return []
  else:
    x1 = x0 + xsize
    y1 = y0 + ysize
  #ここまでで矩形の仮のx0,y0,x1,y1が決まる。
    
  #sozokulistに登録されたオブジェクトとの重複を確認
  objids = canvas.find_overlapping(x0,y0,x1,y1)
  if len(objids):
    if len(sozokulist)==0:
      return [x0,y0,x1,y1]
    for oid in objids:
      for ind in range(0,len(sozokulist)):
        if sozokulist[ind][1]==oid:
          return []
    return  [x0,y0,x1,y1]
  else:
    return [x0,y0,x1,y1]

#--------------------------------------------------------------
#sozokulistからcanvas.id 又は絶対idに対するリストを返す
#idtype: 'cid'=canvasid 'aid'=絶対id
def get_sozokulist(idtype,coraid):
  if idtype=='cid':
    idx = 1
  else: #aid
    idx = 2
  for i in sozokulist:
    if i[idx]==coraid:
      return i
  #memoは複数のidで構成されているが、sozokulistには
  #まとめて１つでcid=0で登録している。
  #従って、canvasが見つけたidではmemoのリストは返せない。
  return []
  
#--------------------------------------------------------------
#sozokulistから絶対idに対応するインスタンスを返す
def sozoku_insta(aid):
  idx = sozoku_idx(aid)
  return sozokulist[idx][0]

#--------------------------------------------------------------
#sozokulistから絶対idに対応するcanvas-idを返す
def sozoku_canvasid(aid):
  idx = sozoku_idx(aid)
  return sozokulist[idx][1]

#--------------------------------------------------------------
#相続インスタンスのリストからabsid（絶対id）に該当するインデックスを返す
#ラインも同じ配列で処理
def sozoku_idx(aid):
  idx=0
  for idx in range(0,len(sozokulist)):
    if sozokulist[idx][2]==aid:
      break
  #該当なしはありえないけど
  if idx == len(sozokulist):
    messagebox.showerror('致命的エラー','相続リストに該当なし！')
    root.quit()
  return idx

#--------------------------------------------------------------
#マウスクリックで相続矩形作成
def add_sozoku(event):
  if mode.get() == 'Box':
    #クリック位置から矩形の座標生成
    zahyo = sozoku_zahyo(canvas.canvasx(event.x),canvas.canvasy(event.y))
    if len(zahyo) == 4:
      #Sozokuインスタンスを作成して矩形IDとともにリストに登録
      insta = Sozoku(zahyo)
      #Box追加して氏名等入力をOKした場合
      if not insta.edit_cancel:
        sozokulist.append([insta,insta.kuid,insta.absid])
        global undolist
        undolist.append(['ADD','BOX',pi.dumps(insta,2)])
      else:
        canvas.delete(insta.kuid)

#--------------------------------------------------------------
#マウスクリックでメモテキスト追加
def add_memotext(event):
  if mode.get()=='Tex' or boxmemo_flg:  #boxmemo対応
    cx,cy = canvas.canvasx(event.x),canvas.canvasy(event.y)
    #他のメモの上なら中止
    tpl = canvas.find_closest(cx,cy)
    if len(tpl):
      tg = canvas.gettags(tpl[0])
      if 'memo' in tg:
        return
    memoinsta=MemoText(cx,cy)
    if memoinsta.empty:
      memoinsta=None
    else:
      #undo準備
      global undolist
      undolist.append(['ADD','MEMO',pi.dumps(memoinsta)])
      #メモテキストはidを登録しない（1字毎にidができるから）
      sozokulist.append([memoinsta,0,memoinsta.absid])
      #変更
      set_modified()
    #boxmemoの場合は後処理が必要  #boxmemo対応
    if boxmemo_flg:
      addboxmemo()

#--------------------------------------------------------------
#直前操作の取り消し（undo）
def undo():
  #undolistの最後から１つ取り出して元に戻す
  global undolist
  global undo_flg
  global sozokulist
  global default_box_styles
  if not len(undolist):
    return
  undo_flg = True
  did,target,instadmp = undolist.pop()
  if did == 'MOVALL':
    mvlist = instadmp
  #elif did == 'CHGALL' or did =='INIT':
  elif did=='DEL' and (target=='LINE' or target=='BOX'):
    dellist = instadmp
  elif did=='ROWINS' or did=='COLUMNINS':
    mvlist = instadmp
  elif did =='ROWRMV' or did=='COLUMNRMV':
    rmvlist = instadmp
  elif did == 'MOV' and (target=='BOX' or target=='LINE'):
    mvlist = instadmp
  elif did == 'CHGSHEETSIZE':
    orgsize = instadmp
  elif did == 'CHGDSPFONT':
    undofontname = instadmp
  elif did == 'CHGBOXDEF':
    prevstyle = instadmp
  elif did =='CHGSTYLEALL':
    instalist = pi.loads(instadmp)
  elif did == 'BOXIN' or did == 'BOXOUT':
    idlist = instadmp
  else:
    insta = pi.loads(instadmp)

  #---------------------------------func --- begin ------↓
  def undo_delbox(dellist):
    for dmp in dellist:
      insta = pi.loads(dmp)
      if insta.type == 'box':
        sozokulist.append([insta,insta.kuid,insta.absid])
        insta.redraw()
      elif insta.type == 'line':
        sozokulist.append([insta,insta.lineid,insta.absid])
        insta.redraw()
        #接続先のBOXorLINEに復元したlineのabsidを設定
        for ai in insta.frtoids:
          sozoku_insta(ai).addlineid(insta.absid)
      elif insta.type == 'memo':
        sozokulist.append([insta,0,insta.absid])
        insta.redraw()
        #連動するBoxのmemoidsに登録 先にBoxが復元されていること
        sozoku_insta(insta.boxid).memoids.append(insta.absid)

  def undo_delline(dellist):
    for dmp in dellist:
      insta = pi.loads(dmp)
      sozokulist.append([insta,insta.lineid,insta.absid])
      insta.redraw()
      #接続先のBOXorLINEに復元したlineのabsidを設定
      for ai in insta.frtoids:
        sozoku_insta(ai).addlineid(insta.absid)

  def undo_delmemo(insta):
    insta.redraw()
    sozokulist.append([insta,0,insta.absid])
    #連動メモの場合
    if hasattr(insta,'boxid'):
      if insta.boxid:
        #Boxのmemoidsにmemoのaidを追加
        if hasattr(sozoku_insta(insta.boxid),'memoids'):
          if not insta.absid in sozoku_insta(insta.boxid).memoids:
            sozoku_insta(insta.boxid).memoids.append(insta.absid)
        else:
          sozoku_insta(insta.boxid).memoids = [insta.absid]

  #----------------------------------func  --- end ------↑

  if target=='BOX':   #ボックス
    if did =='ADD' or did =='PASTE':
      #BOX削除
      #Boxを一旦削除して復活すると最初のkuidが変わるので
      #絶対idから現在のinsta取得してからundo処理
      solist = get_sozokulist('aid',insta.absid)
      solist[0].deleteme()
    elif did == 'CHG' or did == 'REPLACE':
      #テキストデータやスタイルの変更取り消し
      #kuidは変わっている可能性あり
      aid = insta.absid
      cid = get_sozokulist('aid',insta.absid)[1]
      insta = None
      #solist = tuple(solist)
      #一旦Boxを消す(.deleteme()ではラインも一緒に消えるので
      canvas.delete(cid)
      canvas.delete(str(aid)+'atrb')
      canvas.delete(str(aid)+'diag')
      #sozokulistのインスタンス情報を一旦クリア
      #sozokulist[sozoku_idx(aid)][0]=None  #ちょっとやり過ぎ
      #改めてpickleから復元してインスタンスを登録
      sozokulist[sozoku_idx(aid)][0] = pi.loads(instadmp)
      #再描画
      sozokulist[sozoku_idx(aid)][0].redraw()
    elif did == 'MOV':
      #逆順にせずにそのまま復元
      for mvl in mvlist:
        if mvl[0]=='BOX':
          baid = mvl[1]
          solist = get_sozokulist('aid',baid)
          mx,my = mvl[2]
          #box
          canvas.move(solist[1],mx,my)
          #テキスト
          canvas.move(str(baid)+'atrb',mx,my)
          #斜線
          canvas.move(str(baid)+'diag',mx,my)
          #連動メモdef undo():

          canvas.move(str(baid)+'boxmemo',mx,my)
          #座標更新
          solist[0].kukei = canvas.coords(solist[1])
        elif mvl[0]=='LINE':
          laid = mvl[1]
          solist = get_sozokulist('aid',laid)
          canvas.coords(solist[1],*mvl[2])
          #座標更新
          solist[0].linecoords = canvas.coords(solist[1])
    elif did =='DEL':
      dellist.reverse()
      undo_delbox(dellist)
          
  elif target=='LINE':  #ライン
    if did =='ADD':
      insta.delline_sub()
    elif did == 'CHG':
      #直接削除して従前データで描画する
      aid = insta.absid
      cid = get_sozokulist('aid',aid)[1]
      insta = None
      canvas.delete(cid)
      sozokulist[sozoku_idx(aid)][0] = None
      sozokulist[sozoku_idx(aid)][0] = pi.loads(instadmp)
      sozokulist[sozoku_idx(aid)][0].redraw()
    elif did == 'MOV':
      for li in mvlist:
        laid,coords = li
        linsta,lcid,dmy = get_sozokulist('aid',laid)
        canvas.coords(lcid,*coords)
        #canvas.coords(insta.lineid,*insta.linecoords)
    elif did =='DEL':
      dellist.reverse()
      undo_delline(dellist)

  elif target=='MEMO':  #メモ
    if did =='ADD':
      insta.deleteme()
    elif did == 'CHG':
      #Undoの前に現在のメモをdeleteme()を使わずに一旦削除
      #sozokulistに元のインスタンスを登録しなおして、再描画
      aid=insta.absid
      insta = None
      canvas.delete(str(aid)+'memo')
      sozokulist[sozoku_idx(aid)][0] = pi.loads(instadmp)
      sozokulist[sozoku_idx(aid)][0].redraw()
    elif did == 'MOV':
      #文字は１文字毎なのでmoveでなければならない
      #mv = 元座標ー現座標
      mvx = insta.coords[0] - sozoku_insta(insta.absid).coords[0]
      mvy = insta.coords[1] - sozoku_insta(insta.absid).coords[1]
      canvas.move(str(insta.absid)+'memo',mvx,mvy)
    elif did =='DEL':
      undo_delmemo(insta)
      #boxmemoの場合：box側のアトリビュート調整
      if insta.boxid:
        sozoku_insta(insta.boxid).memoids.append(insta.absid)
    elif did == 'BOXIN':
      sozoku_insta(idlist[0]).boxid = None
      sozoku_insta(idlist[1]).memoids.remove(idlist[0])
      #memoのタグからBoxidのタグを削除
      canvas.dtag(str(sozoku_insta(idlist[0]).absid)+'memo',
                  str(sozoku_insta(idlist[1]).absid)+'boxmemo')
      messagebox.showinfo('undo','連動メモへの変更を取り消しました。（→通常メモ）')
    elif did == 'BOXOUT':
      sozoku_insta(idlist[0]).boxid = idlist[1]
      sozoku_insta(idlist[1]).memoids.append(idlist[0])
      #memoにタグを追加
      canvas.addtag_withtag(str(sozoku_insta(idlist[1]).absid)+'boxmemo',
                            str(sozoku_insta(idlist[0]).absid)+'memo')
      messagebox.showinfo('undo','通常メモへの変更を取り消しました。（→連動メモ）')
  elif target=='ALL':   #全体
    #----------------------func---------------------begin-----↓
    def move(solist,mvdst):
      dx,dy = mvdst
      if solist[0].type == 'box':
        #boxは直接移動
        canvas.move(solist[0].kuid,dx,dy)
        #boxにはtextオブジェクトも付属
        canvas.move(str(solist[2])+'atrb',dx,dy)
        canvas.move(str(solist[2])+'diag',dx,dy)
      elif solist[0].type == 'line':
        canvas.move(solist[0].lineid,dx,dy)
      elif solist[0].type == 'memo':
        canvas.move(str(solist[0].absid)+'memo',dx,dy)

    def premove(mvlist):
      for mvt in mvlist:
        #mvt -> [absid or [absidlist], [Δx,Δy] or [coords] ]
        if isinstance(mvt[0],list):
          #絶対idのリストの場合,mvt[1]は[Δx,Δy]
          for aid in mvt[0]:
            #aid毎に移動
            solist = get_sozokulist('aid',aid)
            move(solist,mvt[1])
        elif len(mvt[1])>2:
          #単体の絶対id、.coords()で移動 lineのみ
          solist = get_sozokulist('aid',mvt[0])
          canvas.coords(solist[0].lineid,*mvt[1])
        else:
          #単体の絶対id、.move()で移動
          solist = get_sozokulist('aid',mvt[0])
          move(solist,mvt[1])
    #------------------------------------------------func--end--↑
    if did =='MOVALL':
      canvas.move('sozoku',*mvlist)
      for soinsta,dmyid1,dmyid2 in sozokulist:
        soinsta.setcoords()
    elif did=='ROWINS' or did=='COLUMNINS':
      mvlist.reverse()
      premove(mvlist)
    elif did=='ROWRMV' or did=='COLUMNRMV':
      rmvlist.reverse()
      for li in rmvlist:
        if li[0]=='MOV':
          mvlist = li[1]
          mvlist.reverse()
          premove(mvlist)
        elif li[0]=='DEL':
          dellist = li[2]
          if li[1]=='BOX':
            dellist.reverse()
            undo_delbox(dellist)
          elif li[1]=='MEMO':
            memoinsta = pi.loads(dellist)
            undo_delmemo(memoinsta)
    elif did == 'CHGSHEETSIZE':
      global xmax,ymax
      xmax,ymax = orgsize
      #キャンバスのscrollreginを変更
      canvas.configure(scrollregion=(0,0,xmax,ymax))
      #グリッドラインを消去
      del_gridlines()
      #グリッドライン再表示
      gridlines()
      #souzokuオブジェクトのid取得
      soids = canvas.find_withtag('sozoku')
      if len(soids):
        if isinstance(soids,tuple):
          soids = list(soids)
        soids.sort()
        #display list上のグリッドラインの順位を下げる
        canvas.tag_lower('gridline', soids[0])
      messagebox.showinfo('Undo情報','シートサイズ変更を取り消しました。')
    elif did == 'CHGDSPFONT':
      changedispfont_sub(undofontname)
    elif did == 'CHGBOXDEF':
      default_box_styles = prevstyle
      messagebox.showinfo('Undo情報',
                          'Boxスタイル既定値の変更を\n取り消しました。')
    elif did == 'CHGSTYLEALL':
      #一旦全部のBOXを削除
      canvas.delete('box')
      #再描画
      for insta in instalist:
        #sozokulistのインスタンスを置き換え
        sozokulist[sozoku_idx(insta.absid)][0] = insta
        insta.redraw()
        
  undo_flg = False

#---------------------------------------------------------
#メニューバーをクリックしたとき
def pre_menu_bar(opt):
  #Undoリストが空の場合はundoメニューをdisabledに
  if len(undolist):
    edit_menu.entryconfig(0,state='normal')
  else:
    edit_menu.entryconfig(0,state='disabled')
  #Lineの２つ目の接続先を選択中
  if mode.get()=='Lin' and len(line_target)==1:
    line_cancel()
  #boxmemo追加中又はboxmemoに変更中の場合は中止
  if boxmemo_flg and boxmemo_func:
    boxmemo_func()

#---------------------------------------------------------
#モード変更（一緒にメニューラベルも変更する）
#def mode_change(name,index,tracemode):
#Variable Class .trace('w',callback)のcallback関数だが
#渡される３つの引数はどれも使わない。*argsでまとめた
#マウスクリックのバインドが重複しないようにバインドを追加するときに
#以前のバインドを削除するようにした。
def mode_change(*args):
  global mode_func_id
  s_mode = mode.get()
  if mode_func_id:
    canvas.unbind('<Button-1>',mode_func_id)
    mode_func_id = ''
  if s_mode == 'Box':
    label_set("M)Box追加",'black','yellow')
    mode_func_id = canvas.bind('<Button-1>',add_sozoku,'+')
  elif s_mode == 'Del':
    label_set("M)削除モード",'red','white')
  elif s_mode=='Lin':
    label_set("M)Line追加",'white','blue')
  elif s_mode=='Tex':
    label_set("M)Memo追加",'white','green')
    mode_func_id = canvas.bind('<Button-1>',add_memotext,'+')
  elif s_mode == 'RcIns':
    label_set("M)行列挿入モード",'blue','yellow')
  elif s_mode == 'RcRmv':
    label_set("M)行列削除モード",'red','yellow')
  else:
    label_set("M)標準モード",'','')

#----------------------------------------------------------
#メニューラベル変更
def label_set(label_name,fcolor,bcolor):
  global label_str
  idx = menu_bar.index(label_str)
  label_str = label_name
  menu_bar.entryconfig(idx,label=label_str,
                       foreground=fcolor,background=bcolor)

#----------------------------------------------------------
#全体移動量入力ダイアログ                   class MoveDlg
#全体移動の量を行、列数で指定する
#----------------------------------------------------------
class MoveDlg(simpledialog.Dialog):
  
  def __init__(self,parent,title=None):
    if not 'e1text' in dir(self):
      self.e1text = '左(-)右(+)移動量（列数）:'
      self.e2text = '上(-)下(+)移動量（行数）:'
      self.re_str = '^[\+|\-]?[1-9][0-9]?$'
      self.errmsg = '(+/-)1〜99までの半角数字'
    super().__init__(parent,title)
    
  def body(self,master):
    self.result = []  #承継元のアトリビュートを上書き
    Label(master,
          #text='左(-)右(+)移動量（列数）:',
          text = self.e1text,
          #font=(dispfontname,'10')).grid(row=0)
          font=('','10')).grid(row=0) #システム標準のフォント
    Label(master,
          #text='上(-)下(+)移動量（行数）:',
          text = self.e2text,
          #font=(dispfontname,'10')).grid(row=1)
          font=('','10')).grid(row=1) #システム標準のフォント
    #入力検証関数のラッパー
    wrap_is_valid = master.register(self.is_valid)
    wrap_invalid = master.register(self.invalid)
    self.parent = master
    #エントリー
    self.e1 = Entry(master,width=5,
                    validate='all',
                    validatecommand=(wrap_is_valid,'%P','%V','%W'),
                    invalidcommand=(wrap_invalid,'%W'))
    self.e2 = Entry(master,width=5,
                    validate='all',
                    validatecommand=(wrap_is_valid,'%P','%V','%W'),
                    invalidcommand=(wrap_invalid,'%W'))
    self.e1.grid(row=0, column=1)
    self.e2.grid(row=1, column=1)
    return self.e1 # initial focus

  def apply(self):
    #first = int(self.e1.get())
    estr = self.e1.get()
    first = int(estr.strip()) if len(estr.strip()) else 0
    #second = int(self.e2.get())
    estr = self.e2.get()
    second = int(estr.strip()) if len(estr.strip()) else 0
    self.result = [first,second]

  def ok(self, event=None):
    if not self.validate():
      self.initial_focus.focus_set() # put focus back
      return
    self.withdraw()
    self.update_idletasks()

    try:
      self.apply()
    finally:
      self.cancel()

  def validate(self):
    def rematch(ent):
      if not re.match(
        #'^[\+|\-]?[1-9][0-9]?$',ent):
        self.re_str,ent):
        messagebox.showerror('入力エラー',
                             #'(+/-)1〜99までの半角数字')
                             self.errmsg)
        return False
      else:
        return True
    e1 = self.e1.get().strip()
    e2 = self.e2.get().strip()
    if len(e1):
      if not rematch(e1):
        return False
    if len(e2):
      if not rematch(e2):
        return False
    return True


  #入力の検証
  def is_valid(self,value,reason,wd):
    if reason=='focusout':
      if re.match(
        #'^[\+|\-]?[1-9][0-9]?$',value):
        self.re_str,value):
        return True
      else:
        if not len(value):  #入力なしでも可
          return True
        else:
          return False
    else:
      return True

  #入力エラーへの対応
  def invalid(self,wd):
    messagebox.showerror('入力エラー',
                         #'(+/-)1〜99までの半角数字')
                         self.errmsg)
    #フォーカスを移動させない
    #self.parent.nametowidget(wd).focus_set()
    self.initial_focus.focus_set()
#-----------------------------------class MoveDlg --- end

#----------------------------------------------------------
#全体移動
#シート上のオブジェクトを行・列単位で移動させる
def mov_all():
  if not len(sozokulist):
    return
  movd = MoveDlg(root,'全体移動量')
  if len(movd.result)==0:
    return
  else:
    allmovx,allmovy = movd.result

  #行、列数からピクセル量に換算
  allmovx = xttl*allmovx
  allmovy = yttl*allmovy
  #移動量はキャンバススクロールの制限内か？
  #sozokuタグのアイテムのみ移動（グリッド線は移動しない）
  bbx = canvas.bbox('sozoku')
  msg=""
  if bbx[0]+allmovx < xmargin-10: #bboxに誤差あり
    msg='左右移動が範囲外です'
  if bbx[1]+allmovy < ymargin-10: #bboxに誤差あり
    msg='上下移動が範囲外です'
  if bbx[2]+allmovx > xmax:
    msg='左右移動が範囲外です'
  if bbx[3]+allmovy > ymax:
    msg='上下移動が範囲外です'
  if len(msg):
    messagebox.showerror("入力エラー",msg)
    return
  #undo準備
  global undolist
  undolist.append(['MOVALL','ALL',[-allmovx,-allmovy]])
  #全体移動
  canvas.move('sozoku',allmovx,allmovy)
  #各パーツの座標保持変数の更新
  for instance,dmyid1,dmyid2 in sozokulist:
    instance.setcoords()
  #変更
  set_modified()

#----------------------------------------------------------
#キャンバススクロール範囲変更入力ダイアログ    class ScrlRgnDlg
#----------------------------------------------------------
class ScrlRgnDlg(simpledialog.Dialog):
  def body(self,master):
    self.result = []  #承継元のアトリビュートを上書き
    Label(master, text='水平方向の最大ドット数:',
          #font=(dispfontname,'10')).grid(row=0)
          font=('','10')).grid(row=0)   #システム標準のフォント
    Label(master, text='垂直方向の最大ドット数:',
          #font=(dispfontname,'10')).grid(row=1)
          font=('','10')).grid(row=1)   #システム標準のフォント
    #入力検証関数のラッパー
    wrap_is_valid = master.register(self.is_valid)
    wrap_invalid = master.register(self.invalid)
    self.parent = master

    #エントリー
    self.e1 = Entry(master,width=5,
                    validate='all',
                    validatecommand=(wrap_is_valid,'%d','%P','%V','%W'),
                    invalidcommand=(wrap_invalid,'%W'))
    #現在のX方向の値
    self.e1.delete(0,END)
    self.e1.insert(END,xmax)
    
    self.e2 = Entry(master,width=5,
                    validate='all',
                    validatecommand=(wrap_is_valid,'%d','%P','%V','%W'),
                    invalidcommand=(wrap_invalid,'%W'))
    #現在のY方向の値
    self.e2.delete(0,END)
    self.e2.insert(END,ymax)
    
    self.e1.grid(row=0, column=1)
    self.e2.grid(row=1, column=1)
    return self.e1 # initial focus

  def buttonbox(self):
    box = Frame(self)
    self.okbtn = Button(box, text="OK", width=10, command=self.ok,state=NORMAL)
    self.okbtn.pack(side=LEFT, padx=5, pady=5)
    w = Button(box, text="Cancel", width=10, command=self.cancel)
    w.pack(side=LEFT, padx=5, pady=5)
    #self.bind("<Return>", self.ok)
    self.bind("<Escape>", self.cancel)
    box.pack()

  def apply(self):
    #first = int(self.e1.get())
    estr = self.e1.get()
    first = int(estr.strip()) if len(estr.strip()) else 0
    #second = int(self.e2.get())
    estr = self.e2.get()
    second = int(estr.strip()) if len(estr.strip()) else 0
    self.result = [first,second]

  def ok(self, event=None):
    if not self.validate():
      self.initial_focus.focus_set() # put focus back
      return
    self.withdraw()
    self.update_idletasks()

    try:
      self.apply()
    finally:
      self.cancel()

  #OKボタンが押されたときに入力値の確認
  def validate(self):
    def rematch(ent):
      if not re.match('^[1-9][0-9]{3}$',ent):
        messagebox.showerror('入力エラー','1000〜9999までの半角数字')
        return False
      else:
        return True
    e1 = self.e1.get().strip()
    e2 = self.e2.get().strip()
    if len(e1):
      if not rematch(e1):
        return False
    if len(e2):
      if not rematch(e2):
        return False
    return True
    
  #入力の検証
  #エントリー間を移動するときはフォーカス移動が捉えれられるが
  #直接マウスでokボタンを押すとフォーカス移動が捉えられないので
  #OKボタンのvalidate()で不正値はフォーカスを戻す
  def is_valid(self,why,value,reason,wd):
    if reason=='focusout':
      if re.match('^[1-9][0-9]{3}$',value):
        return True
      else:
        if not len(value):  #入力なしでも可
          return True
        else:
          return False
    else:
      return True

  #入力エラーへの対応
  def invalid(self,wd):
    messagebox.showerror('入力エラー','1000〜9999までの半角数字')
    #フォーカスを移動させない
    #self.parent.nametowidget(wd).focus_set()
    self.initial_focus.focus_set()
#---------------------------------------------ScrlRgnDlg  end

#--------------------------------------------------------
#キャンバスのスクロール範囲変更
def scroll_region():
  def sozokuids():
    #box,line,memo
    res = list(canvas.find_withtag('sozoku'))
    if len(res):
      res.sort()
    return res
  
  global xmax,ymax
  #入力ダイアログ
  insta = ScrlRgnDlg(root,'作業シートサイズの変更')
  if not len(insta.result):
    return
  else:
    orgxmax,orgymax = xmax,ymax
    xscrl,yscrl = insta.result
  if xscrl ==0 and yscrl == 0:
    return
  xscrl = xmax if xscrl == 0 else xscrl
  yscrl = ymax if yscrl == 0 else yscrl
  if xscrl == xmax and yscrl == ymax:
    return
  xscrl = minscrlrgnx if minscrlrgnx > xscrl else xscrl
  yscrl = minscrlrgny if minscrlrgny > yscrl else yscrl
  if len(sozokulist):
    #box,line,memoを含む最小の範囲を調査
    coords = list(canvas.bbox('sozoku'))
    coords[2] = (int(coords[2]/100)+1)*100 if coords[2]%100 else coords[2]
    coords[3] = (int(coords[3]/100)+1)*100 if coords[3]%100 else coords[3]
    xscrl = coords[2] if coords[2] > xscrl else xscrl
    yscrl = coords[3] if coords[3] > yscrl else yscrl
  #結果をグローバル変数に格納
  xmax,ymax = xscrl,yscrl
  #canvas上のbox,line,memoのタグがついたidのうち最小のid
  sids = sozokuids()
  if len(sids):
    minid = sids[0]
  #キャンバスのscrollreginを変更
  canvas.configure(scrollregion=(0,0,xmax,ymax))
  #グリッドラインを消去
  del_gridlines()
  #グリッドライン再表示
  gridlines()
  #display list上のグリッドラインの順位を下げる
  if len(sids):
    canvas.tag_lower('gridline', minid)
  #キャンバスのwindowサイズ(ｘ幅)の調整
  if canvas.winfo_width() > xmax:
    canvas.configure(width=xmax)
  #undo情報
  global undolist
  undolist.append(['CHGSHEETSIZE','ALL',[orgxmax,orgymax]])
  #変更
  set_modified()

#------------------------------------------------------
#ボックス上・左のグリッドラインのクラス　
#行列挿入・削除の際の行列選択に必要
#-------------------------------------- class ULGridline
class ULGridline:
  def __init__(self,uorl,coord):
    self.type   = uorl    #upper,left
    self.coord  = coord   #座標（x or y 座標）   
    self.gid    = 0

    self.mkgridline()
    self.set_tag_bind()
    
  def mkgridline(self):
    if self.type == 'upper':
      x0,y0,x1,y1 = 0,self.coord,xmax,self.coord
    else:
      x0,y0,x1,y1 = self.coord,0,self.coord,ymax
    self.gid = canvas.create_line(x0,y0,x1,y1,dash=(3,5),fill='dark gray',
                                  tag=('gridline','upleft',self.type),
                                  activewidth=3,activefill='dark blue')

  def set_tag_bind(self):
    canvas.tag_bind(self.gid,'<ButtonRelease-1>',self.gridlineclick)
    canvas.tag_bind(self.gid,'<Button-1>',self.rc_ins_rmv)

  def rc_ins_rmv(self,event):
    md = mode.get()
    if not(md=='RcIns' or md=='RcRmv'):
      return
    global rc_coord
    rc_coord = self.coord
    rc = 'row' if self.type=='upper' else 'column'
    if md=='RcIns':
      #行列挿入
      onercins(rc)
    elif md == 'RcRmv':
      #行列削除
      onercrmv(rc)
      
  def gridlineclick(self,event):
    global rc_coord
    #標準モードでのみポップアップ
    if mode.get()=='Nor':
##    #ライン追加モードで２番目のボックス指定を待っているときはpopupしない
##    if mode.get() == 'Lin' and len(line_target)==1:
##      return
##    #行・列の挿入・削除モードの時はポップアップしない
##    if mode.get()=='RcIns' or mode.get()=='RcRmv':
##      return
    #外部変数に基準の行、列座標を配置してポップアップメニュー呼び出し
      rc_coord = self.coord
      if self.type=='upper':
        onerow_pop_menu.tk_popup(event.x_root,event.y_root,0)
      else:
        onecolumn_pop_menu.tk_popup(event.x_root,event.y_root,0)
    
#----------------------------------------class ULGridline end

#-----------------------------------------------------
#キャンバスに薄い色のグリッドラインを表示する
#行・列挿入、削除の際の基準線となるグリッドラインはクラスで定義
def gridlines():
  #横ライン
  y0 = ymargin
  while True:
    if y0 >= ymax:
      break
##    canvas.create_line(0,y0,xmax,y0,dash=(3,5),fill='silver',
##                       tag=('gridline','upper'),
##                       activewidth=3,activefill='dark blue')
    ULGridline('upper',y0)
    y0 += ysize
    if y0 >= ymax:
      break
    canvas.create_line(0,y0,xmax,y0,dash=(3,5),fill='dark gray',tag='gridline')
    y0 += yspace

  #縦ライン
  x0 = xmargin
  while True:
    if x0 >= xmax:
      break
##    canvas.create_line(x0,0,x0,ymax,dash=(3,5),fill='silver',
##                       tag=('gridline','left'),
##                       activewidth=3,activefill='dark blue')
    ULGridline('left',x0)
    x0 += xsize
    if x0 >= xmax:
      break
    canvas.create_line(x0,0,x0,ymax,dash=(3,5),fill='dark gray',tag='gridline')
    x0 += xspace

#----------------------------------------------
#グリッドラインを削除する
def del_gridlines():
  canvas.delete('gridline')
  
#----------------------------------------------
#ダミーのイベントコールバック関数
def event_callback(event):
  pass

#----------------------------------------------
#ダミー関数
def dmy_pass():
    pass

#----------------------------------------------
#ラインのポップメニューからスタイル
def linestyle():
  cur_insta.line_style()

#-----------------------------------------------
#ラインのポップメニューから削除
def linedelete():
  global undolist
  res = cur_insta.deleteme()
  #undo情報
  undolist.append(['DEL','LINE',res])
  #変更
  set_modified()

#-----------------------------------------------
#メモのポップメニューからのフォントサイズとスタイル
def memosize():
  cur_insta.fontsize()

#-----------------------------------------------
#メモのポップアップからの編集
def memoedit():
  cur_insta.memo_dblclk_sub()

#-----------------------------------------------
#メモのポップメニューからの削除
def memodelete():
  res = cur_insta.deleteme()
  global undolist
  undolist.append(['DEL','MEMO',res])
  #変更
  set_modified()

#----------------------------------------------
#キャンバスでの右クリック処理（貼り付け）
#貼付けによりBoxの新規作成
#既存Box上での貼り付け処理はsozokuクラスで
def canbtn3(event):
  #ライン追加モードで２番目のボックス指定を待っているときはpopupしない
  if mode.get() == 'Lin' and len(line_target)==1:
    return
  #バッファが空の場合
  if not enable_paste:
    paste_menu.entryconfig(0,state='disabled')
  else:
    paste_menu.entryconfig(0,state='normal')
  #sozokuオブジェクトとの重複
  tpl = canvas.find_closest(canvas.canvasx(event.x),canvas.canvasy(event.y),halo=5)
  if len(tpl):
    if 'sozoku'in canvas.gettags(tpl[0]):
      return
  #ボックス描画可能座標のチェック
  if not sozoku_zahyo(canvas.canvasx(event.x),canvas.canvasy(event.y)):
    return
  global evobj
  evobj = event
  paste_menu.tk_popup(event.x_root,event.y_root,0)

#------------------------------------------------
#ボックスのポップメニューからのスタイル
def popstyle():
  res = cur_insta.looks_conf()
  if res:
    global undolist
    undolist.append(['CHG','BOX',res])

#------------------------------------------------
#ボックスのポップメニューからの削除(Box)
def popdelete():
  res = cur_insta.deleteme()
  if len(res):
    global undolist
    undolist.append(['DEL','BOX',res])
    #変更
    set_modified()

#------------------------------------------------
#ボックスのポップメニューからの編集
def popedit():
  undata = cur_insta.sozoku_edit()
  if len(undata) and not undo_flg:
    global undolist
    undolist.append(undata)
    #変更
    set_modified()

#--------------------------------------------------------
#Boxコピー（相続諸元をバッファにコピー）
def copytobuffer():
  global enable_paste
  global copy_buf
  #if cur_insta.atrb:
  copy_buf = [[cur_insta.zoku,cur_insta.name,cur_insta.birth,
               cur_insta.die,cur_insta.addr],
              [cur_insta.tate_zoku,cur_insta.tate_name,cur_insta.tate_birth,
               cur_insta.tate_die,cur_insta.tate_addr],
              [cur_insta.size_zoku,cur_insta.zoku_bold,cur_insta.zoku_italic],
              [cur_insta.size_name,cur_insta.name_bold,cur_insta.name_italic],
              [cur_insta.size_birth,cur_insta.birth_bold,cur_insta.birth_italic],
              [cur_insta.size_die,cur_insta.die_bold,cur_insta.die_italic],
              [cur_insta.size_addr,cur_insta.addr_bold,cur_insta.addr_italic],
              [cur_insta.dashptn,cur_insta.outlinewidth],
              [cur_insta.zoku_color,cur_insta.name_color,cur_insta.birth_color,
               cur_insta.die_color,cur_insta.addr_color,
               cur_insta.outline_color,cur_insta.bg_color],
              [cur_insta.diagline,cur_insta.diagwidth,cur_insta.diagptrn,
               cur_insta.diagcolor] ]
  #貼り付け可能
  enable_paste = True

#----------------------------------------------
#ボックス内での貼付け（置き換え）
def paste_on_box(opt):
  global undolist
  #undo情報
  undolist.append(['REPLACE','BOX',pi.dumps(cur_insta,2)])
  cur_insta.replace_paste(opt)

#-------------------------------------------------
#通常メモを連動メモに、連動メモを通常メモに
#連動メモか否かでトグル動作
def chgboxmemo():
  global boxmemo_flg
  global boxmemo_bind
  global boxmemo_func
  global undolist
  
  if not boxmemo_flg:
    #通常メモを連動メモに
    if not cur_insta.boxid:
      #フラグを立てる
      boxmemo_flg=True
      #処理中の関数をセット<ESC>で中止させるため
      boxmemo_func = chgboxmemo
      #連動対象のBoxをマウスクリックで指定→　処理はBoxクラスで定義  
      #メモ表示色変更
      canvas.itemconfigure(str(cur_insta.absid)+'memo',
                           fill=now_boxmemo_color)
      
    else: #連動メモを通常メモに
      #undo準備
      undodata = [cur_insta.absid,cur_insta.boxid]
      #BOXのmemoidsからメモのidを削除
      sozoku_insta(cur_insta.boxid).memoids.remove(cur_insta.absid)
      #memoのboxmemoタグを削除
      canvas.dtag(str(cur_insta.absid)+'memo',
                  str(cur_insta.boxid)+'boxmemo')
      #memoのboxidをクリア
      cur_insta.boxid=None
      #undolist
      if not undo_flg:
        undolist.append(['BOXOUT','MEMO',undodata])
      messagebox.showinfo('メモ','通常メモに変更しました。')
      set_modified()
      
  else: #フラグが立っている場合
    #連動メモ処理終了
    #色
    canvas.itemconfigure(str(cur_insta.absid)+'memo',
                         fill=cur_insta.memo_color)
    #フラグ
    boxmemo_flg = False
    #指定中止用関数クリア
    boxmemo_func = None
    
#-------------------------------------------------
#ボックスのポップアップメニューからの連動メモ作成
#呼び出したBoxのインスタンスは外部変数cur_insta
def addboxmemo():
  global boxmemo_flg
  global boxmemo_bind
  global boxmemo_func
  
  if not boxmemo_flg:
    #フラグを立てる
    boxmemo_flg = True
    #処理中の関数をセット
    boxmemo_func = addboxmemo
    #<button-1>のバインドをadd_memotextに。バインド情報を外部変数に残す
    boxmemo_bind = canvas.bind('<Button-1>',add_memotext,'+')  
    #BOX着色
    canvas.itemconfigure(cur_insta.kuid,fill=now_boxmemo_color)
  else:
    #連動メモ処理終了
    canvas.unbind('<Button-1>',boxmemo_bind)
    canvas.itemconfigure(cur_insta.kuid,fill=cur_insta.bg_color)
    boxmemo_flg = False
    #指定中止用関数クリア
    boxmemo_func = None
  
#----------------------------------------------
#コピーバッファ　クリア
def clear_copybuf():
  global enable_paste
  global copy_buf
  enable_paste = False
  copy_buf = []

#---------------------------------------------------
#貼り付け処理（ボックス作成が可能な位置で貼り付け）
#ボックス作成して諸元を貼り付けして編集
def pastefrombuf(opt):
  ###ボックス作成時の引数にTrueを付ける
  #インスタンス作成時に貼り付けオプションを渡す
  #evobj.x,evobj.y
  #クリック位置から矩形の座標生成
  global sozokulist
  global undolist
  zahyo = sozoku_zahyo(canvas.canvasx(evobj.x),canvas.canvasy(evobj.y))
  if len(zahyo) == 4:
    #Sozokuインスタンスを作成して矩形IDとともにリストに登録
    insta = Sozoku(zahyo,opt)
    sozokulist.append([insta,insta.kuid,insta.absid])
    #undo情報
    undolist.append(['PASTE','BOX',pi.dumps(insta,2)])

#---------------------------------------------------
#バックアップファイルのreパターン文字列を返す
def get_bkfptrn():
  restr = '^[0-9]{4}(\.[0-9]{2}){2}_'   #year,month,day
  restr += '([0-9]{2}-){2}[0-9]{2}'     #hh,mm,ss
  restr += bkfname + '$'
  return restr

#---------------------------------------------------
#バックアップ用ディレクトリを設定
def set_bkfdir():
  global bkfdir
  #スクリプトのあるディレクトリ
  #workdir = os.path.abspath(os.path.dirname(__file__))
  #frozen環境では__file__が使えないので修正
  if getattr(sys,'frozen',False):
    #sysオブジェクトにfrozenアトリビュートが存在すればその値が
    #frozenアトリビュートが存在しなければFalseが返る
    #つまり、Trueならfrozen環境ということになる
    workdir = os.path.dirname(sys.executable)
  else:
    #frozen環境ではない。
    workdir = os.path.dirname(os.path.realpath(__file__))
  #バックアップ保存用のフォルダの存在確認
  if os.path.exists(workdir + '/'+bkfdirname):
    if os.path.isdir(workdir + '/'+bkfdirname):
      bkfdir = workdir + '/'+bkfdirname
    else:  #存在するのは一般ファイルなのでスクリプトのあるディレクトリに
      bkfdir = workdir
  else: #バックアップ用ディレクトリ作成
    os.mkdir(workdir+'/'+bkfdirname)
    bkfdir = workdir + '/'+bkfdirname

#---------------------------------------------------
#バックアップファイルのリストを返す
#スクリプトのあるディレクトリの下にsozoku_unsavedフォルダがなければ作成する
#リストアップ時に超過のバックアップファイルを削除する
def get_bkflist():
  global bkf_over
  set_bkfdir()
  filelist = os.listdir(bkfdir)
  restr = get_bkfptrn()
  bkflist = [fn for fn in filelist if re.match(restr,fn)]
  bkfcnt = len(bkflist)
  if bkfcnt > 1:
    bkflist.sort()
    #すでにファイル数が超過していたら古いものから削除
    if bkfcnt >= bkfmax:
      bkf_over = True
      cnt = bkfcnt - bkfmax
      for i in range(0,cnt):
        os.remove(bkfdir+'/'+bkflist[i])
      bkflist = bkflist[cnt:]
  return bkflist
              
#---------------------------------------------------
#新規のバックアップファイル名を返す
def get_bkfname():
  if not len(bkfdir):
    set_bkfdir()
  now = datetime.datetime.today()
  return bkfdir+'/'+now.strftime('%Y.%m.%d_%H-%M-%S') + bkfname

#---------------------------------------------------
#念の為の保存
def backup_save():
  #相続データがある場合にバックアップ
  ids = canvas.find_withtag('sozoku')
  if len(ids):
    bkflist = get_bkflist()
    newbkf = get_bkfname()
    #バックアップ保存
    saveto(newbkf)
    #バックファイルが一定数以上であれば古いファイルを１つ削除
    if bkf_over:
      #workdir = os.path.abspath(os.path.dirname(__file__))
      os.remove(bkfdir+'/'+bkflist[0])

#---------------------------------------------------
#上書き保存
def saveover():
  if not len(sozokulist):
    messagebox.showinfo('メッセージ','保存すべきデータがありません')
    return
  #filepathnameが''なら名前を付けて保存を実行
  if len(filepathname):
    saveto()
  else:
    saveas()

#---------------------------------------------------
#名前を付けて保存
def saveas():
  global filepathname
  if not len(sozokulist):
    messagebox.showinfo('メッセージ','保存すべきデータがありません')
    return False
  fname = ''

  #filepathnameがあればそれを指定してファイルダイアログを開く
  if len(filepathname):
    fname = get_fname_with_fpath(filepathname,'.sav')
  else:
    fname = filedialog.asksaveasfilename()
  if not len(fname):
    return False
  else:
    #ファイルのパス名をfilepathnameにセット
    filepathname = fname
    saveto()
    root.title('相続関係図：'+os.path.basename(filepathname)+\
               '（'+filepathname+'）')
    clear_modified()
    return True
    
#---------------------------------------------------
#保存実行
def saveto(savefile=None):
  if not len(sozokulist):
    messagebox.showinfo('メッセージ','保存すべきデータがありません')
    return
  #sozokulistに登録されている各インスタンスのsetcoordsをコール
  for instance,dmyid1,dmyid2 in sozokulist:
    instance.setcoords()
  #sozokulistとabsidnow＋α
  #保存した変数名を確認できるように辞書形式で保存
  dic={'sozokulist':sozokulist,'absidnow':absidnow,
       'dispfontname':dispfontname,'xmax':xmax,'ymax':ymax,
       'boxstyles':default_box_styles}
  try:
    if savefile:
      with open(savefile,'wb') as fp:
        pi.dump(dic,fp,2)
    else:
      with open(filepathname,'wb') as fp:
        pi.dump(dic,fp,2)
  except (pi.PicklingError,OSError):
    messagebox.showerror('セーブエラー',"データ保存に失敗しました")
  #保存した
  clear_modified()

#---------------------------------------------------
#ファイルを開く
def loadfrom():
  global filepathname
  global sozokulist
  global absidnow
  global dispfontname
  global xmax,ymax
  global default_box_styles

  #ファイル選択ダイアログを開いてファイルを指定
  fname = filedialog.askopenfilename()
  if not len(fname):
    return
  #対象外のファイルかもしれないのでエラー処理が必要
  try:
    with open(fname,'rb') as fp:
      dic = pi.load(fp)
  except (pi.UnpicklingError,EOFError,OSError):
    messagebox.showerror('ロードエラー',"保存データがロードできません")
    return
  #辞書形式かどうかを確認
  if not isinstance(dic,dict):
    messagebox.showerror('ロードエラー',"保存データ形式が異なります")
    return
  else:
    if not ('sozokulist' in dic and 'absidnow' in dic):
      messagebox.showerror('ロードエラー',"保存データ形式が異なります")
      return
  #ここでシートを初期化------
  if not init_sozoku():  #cancelされた場合
    return
  else:
    #ファイルパス名をセット
    #バックアップファイルから読み込んだ場合はfilepathname=''
    #bkfname = os.path.abspath(os.path.dirname(__file__))+'/'+os.path.basename(backup_file)
    if re.match(get_bkfptrn(),os.path.basename(fname)):
    #if fname==bkfname:
      filepathname=''
      root.title('相続関係図：')
    else:
      filepathname = fname
      root.title('相続関係図：'+os.path.basename(filepathname)+\
                 '（'+filepathname+'）')
  #変数(sozokulist,absidnow,dispfontname)にセット
  sozokulist = dic['sozokulist']
  absidnow = dic['absidnow']
  #dispfontnameに設定する前にシステムに存在するかを確認
  orgdispfont = dispfontname
  #dicにdispfontnameがある場合のみ（ない場合はdispfontnameはそのまま）
  if 'dispfontname' in dic:
    if sedf.sef.is_font_insystem(dic['dispfontname']):
      if dispfontname != dic['dispfontname']:
        messagebox.showinfo('表示フォントの変更',
                            '表示用フォントを保存データの'+\
                            dic['dispfontname']+'に変更します。')
        dispfontname = dic['dispfontname']
    else:
      if messagebox.askyesno('表示フォントの確認',
                             'システムには存在しませんが、表示フォントを\n'+
                             '保存データの'+\
                             dic['dispfontname']+'に変更しますか？'):
        dispfontname = dic['dispfontname']
  if dispfontname != orgdispfont:
    set_font_name(dispfontname)
    setfntmenulabel()
  #dicにxmax,ymaxがある場合のみ（なければxmax,ymaxは初期化された値）
  if 'xmax' in dic and 'ymax' in dic:
    if xmax != dic['xmax'] or ymax != dic['ymax']:
      xmax = dic['xmax']
      ymax = dic['ymax']
      #シート初期化済みだからcanvas.configureとグリッド再描画
      canvas.configure(scrollregion=(0,0,xmax,ymax))
      del_gridlines()
      gridlines()
  if 'boxstyles' in dic:
    default_box_styles = dic['boxstyles']
  #sozokulistに保存された各インスタンスのredrawを実行
  for i in range(len(sozokulist)):
    sozokulist[i][0].redraw()
  #ロード直後
  if len(filepathname):
    clear_modified()
  else:
    set_modified()

#---------------------------------------------------
#Inkscapeでsvgを元にPDFを作成する
def pdfout():
  #出力対象データの有無sozokulist
  if not len(sozokulist):
    messagebox.showinfo('メッセージ','データがありません')
    return
  #保存ファイル名を決定
  if len(filepathname):
    pdfname = get_fname_with_fpath(filepathname,'.pdf')
  else:
    pdfname = filedialog.asksaveasfilename(defaultextension='.pdf')
  if not len(pdfname):
    return
  #tempファイルにsvg出力
  #workdir = os.path.abspath(os.path.dirname(__file__))
  #frozen環境では__file__が使えないので修正
  if getattr(sys,'frozen',False):
    #sysオブジェクトにfrozenアトリビュートが存在すればその値が
    #frozenアトリビュートが存在しなければFalseが返る
    #つまり、Trueならfrozen環境ということになる
    workdir = os.path.dirname(sys.executable)
  else:
    #frozen環境ではない。
    workdir = os.path.dirname(os.path.realpath(__file__))
  now = datetime.datetime.today()
  tmpfile = workdir+'/tmp'+now.strftime('_%S%M%H_%d%m%Y_')
  if svgout(tmpfile):
    #tempをInkscapeでPDF
    cmdsq = 'inkscape -f '+ tmpfile + ' -A '+pdfname
    cmdsq = cmdsq.split()
    try:
      retc = Popen(cmdsq,stdout=PIPE,stderr=PIPE).wait()
    except (ChildProcessError,FileNotFoundError,ValueError,OSError):
      retc = 1
    if retc: #リターンコードが０（正常終了）でない場合
      messagebox.showerror('エラー','PDF出力に失敗しました。')
    else:
      messagebox.showinfo('PDF出力',pdfname+'に出力しました。')
    #一時ファイル削除
    os.remove(tmpfile)
  else:
    messagebox.showerror('エラー','一時ファイル(SVG)出力に失敗しました。')

#---------------------------------------------------
#svgファイルをInkscapeで開く
def inkscape():
  messagebox.showinfo("注意","Inkscapeで開くために一旦svg形式で保存します")
  #svgファイル出力。
  svgfname = svgout()
  if not svgfname:
    return
  #Inkscape with svgfile
  cmdsq = 'inkscape -f ' + svgfname
  cmdsq = cmdsq.split()
  try:
    Popen(cmdsq,stdout=PIPE,stderr=PIPE)
  except (ChildProcessError,FileNotFoundError,ValueError,OSError):
    messagebox.showerror('エラー','Inkscapeの起動に失敗しました。')

#---------------------------------------------- class HV_pages
# MoveDlgから承継
# A4用紙での分割数を縦横枚数で指定する。
# 戻り値：[縦枚数,横枚数]
class HV_pages(MoveDlg):
  def __init__(self,parent,title=None):
    if not 'e1text' in dir(self):   
      self.e1text = 'A4分割　縦枚数:'
      self.e2text = 'A4分割　横枚数:'
      self.re_str = '[1-9][0-9]?$'
      self.errmsg = '1〜99までの半角数字'
    super().__init__(parent,title)

  def apply(self):
    #first = int(self.e1.get())
    estr = self.e1.get()
    first = int(estr.strip()) if len(estr.strip()) else 1
    #second = int(self.e2.get())
    estr = self.e2.get()
    second = int(estr.strip()) if len(estr.strip()) else 1
    self.result = [first,second]

  def validate(self):
    def rematch(ent):
      if not re.match(
        #'^[\+|\-]?[1-9][0-9]?$',ent):
        self.re_str,ent):
        messagebox.showerror('入力エラー',
                             #'(+/-)1〜99までの半角数字')
                             self.errmsg)
        return False
      else:
        return True
    e1 = self.e1.get().strip()
    e2 = self.e2.get().strip()
    if len(e1) and len(e2):
      if int(e1.strip())==1 and int(e2.strip())==1:
        messagebox.showerror('分割数量','分割指定ができていません。')
        return False
    #if len(e1):
    if not rematch(e1):
      return False
    #if len(e2):
    if not rematch(e2):
      return False
      
    return True

#---------------------------------------------- class HV_pages  end

#---------------------------------------------------
#分割印刷用のPSファイルを出力する
#　各ページにカットマージンが入るのでA4用紙１枚で出力可能な図には不向き
#os:Linux, inkscape:True, poster:Trueの環境で動作
#大きな相続図を複数のA4用紙に分割して印刷するイメージ：縦横枚数を指定する。
#作業用のsvgを出力し、inkscapeでEPSに変換し、posterで指定の枚数に出力。
#※#A4用紙固定について：
#CUPSモジュールで接続しているプリンター名を取得してプリンターが対応している
#用紙サイズを取得できるのかもしれないが今のところA4固定で
def psout():
  #出力対象データの有無sozokulist
  if not len(sozokulist):
    messagebox.showinfo('メッセージ','データがありません')
    return
  #保存ファイル名を決定
  if len(filepathname):
    psname = get_fname_with_fpath(filepathname,'.ps')
  else:
    psname = filedialog.asksaveasfilename(defaultextension='.ps')
  if not len(psname):
    return
  #分割数指定
  hvpages = HV_pages(root,'分割枚数指定')
  if not len(hvpages.result):
    return
  #tempファイルにsvg出力
  #workdir = os.path.abspath(os.path.dirname(__file__))
  #frozen環境では__file__は使えないので修正
  if getattr(sys,'frozen',False):
    #sysオブジェクトにfrozenアトリビュートが存在すればその値が
    #frozenアトリビュートが存在しなければFalseが返る
    #つまり、Trueならfrozen環境ということになる
    workdir = os.path.dirname(sys.executable)
  else:
    #frozen環境ではない。
    workdir = os.path.dirname(os.path.realpath(__file__))
  now = datetime.datetime.today()
  tmpfile = workdir+'/tmp'+now.strftime('_%S%M%H_%d%m%Y_')
  epstmpfile = tmpfile + '.EPS'
  if svgout(tmpfile):
    #tempをInkscapeでEPS
    cmdsq = 'inkscape -f '+ tmpfile + ' -E '+ epstmpfile
    cmdsq = cmdsq.split()
    try:
      retc = Popen(cmdsq,stdout=PIPE,stderr=PIPE).wait()
    except (ChildProcessError,FileNotFoundError,ValueError,OSError):
      retc = 1
    if retc: #リターンコードが０（正常終了）でない場合
      messagebox.showerror('エラー','EPS出力に失敗しました。')
    else:
      #poster で　EPS -> ps
      cmdsq = 'poster -p'+ str(hvpages.result[0]) + \
        'x' + str(hvpages.result[1]) + 'A4 ' + \
        epstmpfile + ' -o' + psname
      cmdsq = cmdsq.split()
      try:
        retc2 = Popen(cmdsq,stdout=PIPE,stderr=PIPE).wait()
      except (ChildProcessError,FileNotFoundError,ValueError,OSError):
        retc2 = 1
      if retc2:
        messagebox.showerror('エラー','ps出力に失敗しました。')
      else:
        messagebox.showerror('メッセージ',psname+'に出力しました。')
    #一時ファイル削除
    os.remove(tmpfile)
    if not retc:
      os.remove(epstmpfile)
  else:
    messagebox.showerror('エラー','一時ファイル(SVG)出力に失敗しました。')

#---------------------------------------------------
#filepathnameが決まっている時に初期設定を渡して
#名前を付けて保存のファイルダイアログを開く
#fpath = file_path_name  ext=拡張子('.ext')
def get_fname_with_fpath(fpath,ext):
  #pathnameからフォルダ名、拡張子を除くファイル名取得
  #initialdir,initialfile設定
  pspl = os.path.split(fpath)
  inidir = pspl[0]
  inifile = os.path.splitext(pspl[1])[0] + ext
  fname = filedialog.asksaveasfilename(initialdir=inidir,
                                       initialfile=inifile,
                                       defaultextension=ext)
  return fname

#---------------------------------------------------
#Boxの背景色を指定の色にして再描画
#color=color_name,defbx=defcolorbox_idlist,
#  chgbx=chgcolorbox_idlist,keepflg)
def box_fill(color,defbx,chgbx,flg):
  for cid in defbx:
    canvas.itemconfigure(cid,fill=color)
  if not flg:
    for cid in chgbx:
      canvas.itemconfigure(cid,fill=color)
##  sozokulist_sub = tuple(sozokulist)
##  for solist in sozokulist_sub:
##    if solist[0].type == 'box':
##      canvas.itemconfigure(solist[0].kuid,fill=color)

#--------------------------------------------------------------
#canvasvg.saveall()の上書き------------------------- ここから
def saveall(filename, canvas, items=None, margin=10, tounicode=None):
  #canvasvgの中のSVGdocument()呼び出し
  #doc = SVGdocument()
  doc = svg.SVGdocument()

  #canvasvgの中のconvert()呼び出し
  #for element in convert(doc, canvas, items, tounicode):
  for element in svg.convert(doc, canvas, items, tounicode):
    doc.documentElement.appendChild(element)

  if items is None:
    x1, y1, x2, y2 = canvas.bbox(ALL)
  else:
    x1 = None
    y1 = None
    x2 = None
    y2 = None
    for item in items:
      X1, Y1, X2, Y2 = canvas.bbox(item)
      if x1 is None:
        x1 = X1
        y1 = Y1
        x2 = X2
        y2 = Y2
      else:
        x1 = min(x1, X1)
        x2 = max(x2, X2)
        y1 = min(y1, Y1)
        y2 = max(y2, Y2)

  x1 -= margin
  y1 -= margin
  x2 += margin
  y2 += margin

  dx = x2-x1
  dy = y2-y1
  doc.documentElement.setAttribute('width',  "%0.3f" % dx)
  doc.documentElement.setAttribute('height', "%0.3f" % dy)
  doc.documentElement.setAttribute(
    'viewBox', "%0.3f %0.3f %0.3f %0.3f" % (x1, y1, dx, dy))

  #実質的なオリジナルからの変更点はencodingの追加だけ
  #file = open(filename, 'w')
  file = open(filename, 'w',encoding='utf-8')
  file.write(doc.toxml())
  file.close()
#canvascg.saveall()上書き-------------------- ここまで

#------------------------------------------------------
#印刷用のSVGファイルに出力
def svgout(spsvgname=None):
  global sozokulist
  global absidnow
  if not len(sozokulist):
    messagebox.showinfo('メッセージ','出力するデータがありません。')
    return False
  svgname = ''
  #保存ファイル名が決定済みの場合
  if spsvgname:
    svgname = spsvgname
  else:
    #filepathnameが決まっていれば、その拡張子をsvgにして
    if len(filepathname):
      svgname = get_fname_with_fpath(filepathname,'.svg')
    else:  #filepathnameなし
      svgname = filedialog.asksaveasfilename(defaultextension='.svg')
  if not len(svgname):
    return False
  #Box背景色で基本色以外の設定があるかどうか
  defboxlist = []
  chgboxlist = []
  for insta,cid,aid in sozokulist:
    if insta.type=='box':
      if insta.bg_color==kucolor:
        defboxlist.append(cid)
      else:
        chgboxlist.append(cid)
  #Box背景色維持
  keepcolor_flg = False
  if len(chgboxlist):
    yorn = messagebox.askyesno('Box背景色',
                               'Boxの背景色を白に統一しますか？')
    keepcolor_flg = False if yorn else True
  #キャンバス更新
  #canvas.update()
  #sozokulistに登録されている各インスタンスのsetcoordsをコール
  for instance,dmyid1,dmyid2 in sozokulist:
    instance.setcoords()
  #一時退避
  tmp_dmp = pi.dumps([sozokulist,absidnow],2)
  #グリッドラインを削除
  del_gridlines()
  #canvas.itemconfigure('box',fill='white')
  #BOX内をtag='box'でまとめて白にしようとしたがcanvasvgの処理でエラーになる
  #仕方ないのでcanvas-idを指定して個別に白に
  box_fill('white',defboxlist,chgboxlist,keepcolor_flg)
  #svg.saveall()を上のsaveall()で上書き
  svg.saveall = saveall
  #svgで出力 saveall(filename, canvas, items=None, margin=10, tounicode=None)
  svg.saveall(svgname,canvas,margin=30)
  #キャンバス上のすべてのアイテムを削除
  canvas.addtag_all('delete')
  canvas.delete('delete')
  #グリッドライン描画
  gridlines()
  #復帰
  sozokulist,absidnow = pi.loads(tmp_dmp)
  #sozokulistに保存された各インスタンスのredrawを実行
  for i in range(len(sozokulist)):
    sozokulist[i][0].redraw()
  messagebox.showinfo('SVG出力',svgname+'に出力しました。')
  return svgname

#------------------------------------------------------
#File-新規
def init_sozoku():
  #変更の有無
  if not undo_flg and is_modified():
    #保存の確認と保存処理
    ret = messagebox.askquestion("保存確認",
            "処理を続行する前に\n変更内容を保存しますか？",
            type='yesnocancel')
    if ret == 'yes':
      if not saveas():
        if is_modified():
          backup_save()
    elif ret == 'cancel':
      return False
    elif is_modified():
      backup_save()

  #変数初期化
  global sozokulist
  global absidnow
  global filepathname
  global undolist
  global xmax,ymax
  sozokulist =[]
  absidnow = 0
  filepathname = ''
  undolist = []
  #キャンバス上のアイテム削除
  canvas.addtag_all('delete')
  canvas.delete('delete')
  #キャンバスサイズを既定値に
  xmax = ymax = defmax
  canvas.configure(scrollregion=(0,0,xmax,ymax))
  #グリッドライン
  gridlines()
  #コピーバッファクリア
  clear_copybuf()
  root.title('相続関係図')
  clear_modified()
  return True

#------------------------------------------------------
#エントリーや縦書き用のフォントを設定
def set_font_name(fntname):
  global entryfont,entryfontmini,tatefont
  entryfont = (fntname,'12')
  entryfontmini = (fntname,'8')
  tatefont = fntname
  
#------------------------------------------------------
#起動時に表示用フォントを決定する
def setup_dispfont():
  dfn = sedf.startup_dispfontset(root,dicfile,deffontname,keyname)
  global dispfontname
  dispfontname = dfn[0]
  set_font_name(dispfontname)
  if dfn[1]=='init':
    msg = dispfontname+'：初期フォントを読み込みました'
  elif dfn[1]=='default':
    msg = dispfontname+'：既定フォントを表示フォントに設定しました'
  if dfn[1]=='choice':
    msg = dispfontname+'が表示フォントに選択されました'
    sedf.regist_font(dispfontname,sozokudic,keyname,dicfile)
  elif dfn[1]=='cancel':
    msg = dispfontname+'を表示フォントに設定しました'
  #起動時のメッセージが煩わしいのでchoiceの場合のみ表示
  if dfn[1]=='choice':
    messagebox.showinfo('表示フォント',msg)

#------------------------------------------------------
#表示フォント変更メニューのラベル文字列
def mkfntlabel():
  return '「'+dispfontname+'」を変更する'

#------------------------------------------------------
#表示フォント変更下請け
def changedispfont_sub(fntname):
  if len(fntname):
    global dispfontname
    curfontname = dispfontname
    #dispfontname,entryfont等の設定
    dispfontname = fntname
    set_font_name(dispfontname)
    #メニューラベルの変更
    setfntmenulabel()
    #sozokulistに保存されたboxまたはmemoのインスタンスのredrawを実行
    for i in range(len(sozokulist)):
      if sozokulist[i][0].type == 'box' or sozokulist[i][0].type == 'memo':
        sozokulist[i][0].show_chg_font()    
    #undo情報
    if not undo_flg:
      global undolist
      undolist.append(['CHGDSPFONT','ALL',curfontname])
      set_modified()
  
#------------------------------------------------------
#表示フォントの変更
def changedispfont():
  #set_dispfont.pyの関数呼び出し。初期化ファイルへの書き出しも
  selfont = sedf.menu_dispfontset(root,sozokudic,dicfile,keyname)
  changedispfont_sub(selfont)  
##  if len(selfont):
##    #dispfontname,entryfont等の設定
##    global dispfontname
##    dispfontname = selfont
##    set_font_name(dispfontname)
##    #メニューラベルの変更
##    setfntmenulabel()
##    #sozokulistに保存されたboxまたはmemoのインスタンスのredrawを実行
##    sublist = sozokulist  #念の為
##    for i in range(len(sublist)):
##      if sublist[i][0].type == 'box' or sublist[i][0].type == 'memo':
##        sublist[i][0].show_chg_font()    
##    #アンドゥの初期化
##    global undolist
##    undolist = []
##    #コピーバッファクリア
##    clear_copybuf()
##    set_modified()

#------------------------------------------------------
#表示フォント変更メニューのラベルを変更する
def setfntmenulabel():
  #対象メニューは１つなのでインデックスは０
  labelstr = mkfntlabel()
  font_menu.entryconfig(0,label=labelstr)

#----------------------------------------------------------------
##　複数桁の表示をサポートするメッセージボックス
##　(messagebox.showinfo()の代用)
##　simpledialogクラスから承継する。
##　ボタンはOKのみ
##　コンストラクタに表示データを配列にして渡す。
##　配列：[ [r0c0,r0c1,r0c2,...],  #全体の桁数は1行目の配列要素数による
## 　       [r1c0,r1c1,r1c2,...],
##  　      ...
##   　     [rnc0,rnc1,rnc2,...] ]
class Showinfo_withClumns_dialog(simpledialog.Dialog):
  def __init__(self, parent, title = None, rclist=None ):
    if rclist:
      self.rclist = rclist
    else:
      return
    
    super().__init__(parent,title)
    
  def body(self,master):
    nr = 0
    for line in self.rclist:
      nc = 0
      for itm in line:
        Label(master,text=itm,).grid(row=nr,column=nc,padx=5,pady=5)
        nc += 1
      nr += 1

  def buttonbox(self):
    box = Frame(self)

    w = Button(box, text="OK", width=10, command=self.ok, default=ACTIVE)
    w.pack(side=LEFT, padx=5, pady=5)
    self.bind("<Return>", self.ok)
    box.pack()

#-------------------------------------------------------
#バージョンなどを表示
def verinfo():
  msg = [['バージョン',version],
         ['ホームページ',zenhan.z2h(homepage)],
         ['連絡先',zenhan.z2h(mailaddr)]]
  Showinfo_withClumns_dialog(root,"バージョン表示",msg)

#-------------------------------------------------------
#実行環境表示補助
def isinstalled(tfn):
  return 'インストール済み' if tfn else ('ー'if tfn==None else '未インストール')

#-------------------------------------------------------
#実行環境を表示
def showenv():
  msg = [['os',chkres['os']],
         ['python','.'.join(chkres['vertpl'])],
         ['canvasvg',isinstalled(chkres['canvasvg'])],
         ['zenhan',isinstalled(chkres['zenhan'])],
         ['Inkscape',isinstalled(chkres['inkscape'])],
         ['xte',isinstalled(chkres['xte'])],
         ['poster',isinstalled(chkres['poster'])],
         ['lpr',isinstalled(chkres['lpr'])]]
  Showinfo_withClumns_dialog(root,"実行環境の表示",msg)

#------------------------------------------------------
#マウスドラッグによるキャンバス移動の動作可否
#（マウスドラッグでのキャンバス移動は問題が多いので当面不採用）
def is_dragging_time(event):
  def is_boxarea(x,y):
    #マージン内か
    if x<=xmargin or x>=xmax-xmargin or y<=ymargin or y>=ymax-ymargin:
      return False
    #Box設置位置か
    x0 = int((x-xmargin)/xttl)*xttl+xmargin \
         if (x-xmargin)%xttl <= xsize else 0
    y0 = int((y-ymargin)/yttl)*yttl+ymargin \
         if (y-ymargin)%yttl <= ysize else 0
    if x0==0 or y0==0:
      return False
    else:
      return True
  
  xc = int(canvas.canvasx(event.x))
  yc = int(canvas.canvasy(event.y))
  #メモテキスト追加モードの場合は移動しない
  if mode.get()=='Memo':
    return False
  #BOX追加モードの場合はBOX設置位置以外であること
  if mode.get()=='Box':
    if is_boxarea(xc,yc):
      return False
  #他のオブジェクトと重なっていないこと
  tpl = canvas.find_closest(xc,yc,halo=5)
  if len(tpl):
    if 'sozoku'in canvas.gettags(tpl[0]):
      return False
  return True

#------------------------------------------------------
#マウス押し下げでキャンバス移動開始
#（マウスドラッグでのキャンバス移動は問題が多いので当面不採用）
def cvpressed(event):
  if is_dragging_time(event):
    canvas.scan_mark(event.x,event.y)

#------------------------------------------------------
#マウスドラッグでキャンバス移動
#（マウスドラッグでのキャンバス移動は問題が多いので当面不採用）
def cvdragging(event):
  if is_dragging_time(event):
    canvas.scan_dragto(event.x,event.y,gain=1)

#--------------------------------------------------
#１行・１列 挿入
# op = 'row' or 'column'
def onercins(opt):
  #移動対象のオブジェクトリスト作成
  listdic = get_mvobjslist(opt,rc_coord)
  if len(listdic):
    ins_undolist = onerowcolumninsdel(opt,'ins',listdic)
    global undolist
    nam = 'ROWINS' if opt=='row' else 'COLUMNINS'
    undolist.append([nam,'ALL',ins_undolist])
    #変更
    set_modified()

#---------------------------------------------------
#１行・１列 削除
def onercrmv(opt):
  #削除対象のオブジェクトリスト(Box,Memo)作成
  boxmemodic = get_deleteobjslist(opt,rc_coord)
  #undo準備
  rmv_undolist = []
  if len(boxmemodic):
    boxlist,memolist = boxmemodic['boxlist'],boxmemodic['memolist']
##    #個別にUndo情報がストックされないように、削除はundo_flgをOnにして。
##    global undo_flg
##    undo_flg = True
    #連動メモの扱いが微妙なのでBoxより先にメモを削除
    #memo delete
    for cid in memolist:
      #memoのidはsozokulistに０で登録しているので
      #タグ情報から絶対idを取得して削除する
      memotags = canvas.gettags(cid)
      if len(memotags):
        res = re.match('^([0-9]+)memo$',memotags[2])
        if res:
          aid = res.group(1)
          solist = get_sozokulist('aid',int(aid))
          if len(solist):
            #削除されたmemoのdmps
            rmv_undolist.append(['DEL','MEMO',solist[0].deleteme()])
    #box delete
    for cid in boxlist:
      #boxlistには氏名等のidもあるがrectangleのdeleteの際に一緒に削除される）
      solist = get_sozokulist('cid',cid)
      if len(solist):
        #削除されたbox+lineのdmps
        rmv_undolist.append(['DEL','BOX',solist[0].deleteme()])
##    undo_flg = False
  #基準線以降のオブジェクトを繰り上げ
  listdic = get_mvobjslist(opt,rc_coord)
  if len(listdic):
    rmv_undolist.append(['MOV',onerowcolumninsdel(opt,'del',listdic)])
  #undo準備
  nam = 'ROWRMV' if opt=='row' else 'COLUMNRMV'
  global undolist
  undolist.append([nam,'ALL',rmv_undolist])
  #変更
  set_modified()

#-----------------------------------------------------
#行列挿入時の移動対象のオブジェクトリスト作成
#戻りは辞書
#{'boxmemo':boxmemolist,'enclline':encllinelist,'partline':partlinelist}
def get_mvobjslist(roworclm,coord):
  if not len(sozokulist):
    return {}
  if roworclm=='row':
    x0,y0,x1,y1 = 0,coord,xmax,ymax
  else: #column
    x0,y0,x1,y1 = coord,0,xmax,ymax
  #移動範囲に一部でもかかるオブジェクトのリスト
  idlstovlp = canvas.find_overlapping(x0,y0,x1,y1)
  idlstovlp = [i for i in idlstovlp if 'sozoku' in canvas.gettags(i)]
  if not len(idlstovlp):
    return {}
  #boxmemolist作成
  boxmemolist = [i for i in idlstovlp if 'box' in canvas.gettags(i) or
                 'memo' in canvas.gettags(i)]
  #移動範囲に全体が含まれるオブジェクトのリスト
  idlstencl = canvas.find_enclosed(x0,y0,x1,y1)
  idlstencl = [i for i in idlstencl if 'sozoku' in canvas.gettags(i)]
  #encllinelist作成
  encllinelist = [i for i in idlstencl if 'line' in canvas.gettags(i)]
  #移動範囲に一部しか含まれないオブジェクトのリスト
  partlinelist = list(set(idlstovlp).difference(set(idlstencl)))
  partlinelist = [i for i in partlinelist if 'line' in canvas.gettags(i)]
  #戻り値　辞書形式
  return {'boxmemo':boxmemolist,'enclline':encllinelist,
          'partline':partlinelist}

#-----------------------------------------------------------
#行列削除の際の削除対象(Box,Memo)のオブジェクトリストを返す
#オブジェクトの一部でも含まれるもの
#ただし、xspace,yspaceは−１しないと次の行列のBoxまで削除リストに入る
#戻り値：辞書{'boxlist':boxlist,'memolist':memolist}
def get_deleteobjslist(roworclm,coord):
  if not len(sozokulist):
    return {}
  if roworclm=='row':
    x0,y0,x1,y1 = 0,coord,xmax,coord+ysize+yspace-1
  else: #column
    x0,y0,x1,y1 = coord,0,coord+xsize+xspace-1,ymax
  idlstovlp = canvas.find_overlapping(x0,y0,x1,y1)
  idlstovlp = [i for i in idlstovlp if 'sozoku' in canvas.gettags(i)]
  if not len(idlstovlp):
    return {}
  boxlist = [i for i in idlstovlp if 'box' in canvas.gettags(i)]
  memolist = [i for i in idlstovlp if 'memo' in canvas.gettags(i)]
  return {'boxlist':boxlist,'memolist':memolist}

#----------------------------------------------------------
#座標がLine座標に接しているかどうかを判定
#coord:ポイント座標[x,y]、lcoords:Line座標[x0,y0,x1,y1,...]
def is_on_line(coord,lcoords):
  x,y = coord
  for idx in range(0,len(lcoords),2):
    if idx+2>=len(lcoords):
      break
    x0,y0,x1,y1 = lcoords[idx],lcoords[idx+1],lcoords[idx+2],lcoords[idx+3]
    if x0==x1: #垂直線
      if x==x0 and ((y >= y0 and y <= y1) or (y >= y1 and y <= y0)):
        return True
    elif y0==y1: #水平線
      if y==y0 and ((x >= x0 and x <= x1) or (x >= x1 and x <= x0)):
        return True
  return False

#-----------------------------------------------------
#lineの両端の座標を返す
def get_linecoords_both_ends(listcoords):
  for ci in range(0,len(listcoords),2):
    if ci==0:
      stx = listcoords[ci]
      sty = listcoords[ci+1]
    if ci==len(listcoords)-2:
      edx = listcoords[ci]
      edy = listcoords[ci+1]
  return [[stx,sty],[edx,edy]]

#----------------------------------------------------------
#Line座標coords上でx座標に対するy座標を返す
#Lineの形状によるが、最初に見つかったy座標を返すことになる
def get_ycoord_online(x,coords):
  for idx in range(0,len(coords),2):
    if idx+2 >= len(coords):
      break
    x0,y0,x1,y1 = coords[idx],coords[idx+1],coords[idx+2],coords[idx+3]
    if x0==x1: #垂直
      if x==x0:
        return y0
    elif y0==y1:  #水平
      if (x>=x0 and x<=x1) or (x>=x1 and x<=x0):
        return y0
  return False
##  messagebox.showerror('エラー','想定外：get_ycoord_online')
##  root.quit()

#---------------------------------------------------------
#夫婦ラインの２つの終端を渡して親子ラインとの接続予定点を返す
#Box、Line移動後の接続Lineの後追い移動用
def get_fuhuline_cpoint(fuhucoords):
  end1,end2 = get_linecoords_both_ends(fuhucoords)
  centx = end2[0]+(end1[0]-end2[0])/2 if end1[0]>=end2[0] \
            else end1[0]+(end2[0]-end1[0])/2
  fx = centx if (centx - xmargin)%xttl > xsize \
        else centx + xsize/2 + xspace/2
  fy = get_ycoord_online(fx,fuhucoords)
  return [fx,fy]

#-----------------------------------------------------
#sozokulist内のデータ参照
#キャンバスidリストを受けて該当する絶対idリストを返す
def get_absidlist(cidlist):
  absidlist = set()
  for cid in cidlist:
    insta = get_sozokulist('cid',cid)
    if len(insta):
      absidlist.add(insta[0].absid)
    else:  #sozokulistに該当なし
      #memoなら別にabsidを取得
      tags = canvas.gettags(cid)
      if 'memo' in tags:
        res = re.match('^([0-9]+)memo$',tags[2])
        absidlist.add(int(res.group(1)))
  absidlist = list(absidlist)
  absidlist.sort()
  return absidlist

#-------------------------------------------------------
#１行又は１列挿入・削除統合版（下請け）
#roworclm='row'or'column' insordel='ins'or'del'
def onerowcolumninsdel(roworclm,insordel,listdic):
  #undo処理のために絶対idと元の座標などをリストにして返す
  #  *[absid,orgcoords]
  #    tagを使って複数のオブジェクトを移動している場合は
  #   *[absidlist,逆移動量[x,y]
  # ※絶対idから関連するtagを抽出して‥
  insrmv_undolist = []
  #box,memoをタグ付け移動
  for i in listdic['boxmemo']:
    canvas.addtag_withtag('move',i)
  if roworclm=='row':
    if insordel=='ins':
      canvas.move('move',0,ysize+yspace)
      mvdst = [0,-(ysize+yspace)]
    else: #del
      canvas.move('move',0,-(ysize+yspace))
      mvdst = [0,ysize+yspace]
  else:
    if insordel=='ins':
      canvas.move('move',xsize+xspace,0)
      mvdst = [-(xsize+xspace),0]
    else:  #del
      canvas.move('move',-(xsize+xspace),0)
      mvdst = [xsize+xspace,0]
  for i in listdic['boxmemo']:
    canvas.dtag(i,'move')
  # undo情報
  absidlist = get_absidlist(listdic['boxmemo'])
  insrmv_undolist.append([absidlist,mvdst])

  #encllineをタグ付け移動
  #--夫婦ラインから接続していても接続点も一緒に移動するはず
  for i in listdic['enclline']:
    canvas.addtag_withtag('move',i)
  if roworclm=='row':
    if insordel=='ins':
      canvas.move('move',0,ysize+yspace)
      mvdst = [0,-(ysize+yspace)]
    else:  #del
      canvas.move('move',0,-(ysize+yspace))
      mvdst = [0,ysize+yspace]
  else:
    if insordel=='ins':
      canvas.move('move',xsize+xspace,0)
      mvdst = [-(xsize+xspace),0]
    else:  #del
      canvas.move('move',-(xsize+xspace),0)
      mvdst = [xsize+xspace,0]
  for i in listdic['enclline']:
    canvas.dtag(i,'move')
  #undo 情報
  absidlist = get_absidlist(listdic['enclline'])
  insrmv_undolist.append([absidlist,mvdst])

  #partline除外リスト
  partlineexc = []
  #partlineはcanvas.coords()で再描画
  for i in listdic['partline']:
    if i in partlineexc:
      continue
    #自身のLine座標取得
    listcoords = canvas.coords(i)
    #solist->[insta,cid,absid]
    solist = get_sozokulist('cid',i)
    #Line type('fuhu'or'oyako')
    linetype = solist[0].twoof
    #接続先の絶対id
    fraid,toaid = solist[0].frtoids
    #接続先のインスタンス
    frinsta = sozoku_insta(fraid)
    toinsta = sozoku_insta(toaid)
    #接続先がlineならそのlineは夫婦Line
    if frinsta.type == 'line':
      #婚姻ラインと接続したラインの接続点の座標を得る--------------↓
      #現line座標の両端（始点、終点）座標取得
      bothends = get_linecoords_both_ends(listcoords)
      stx,sty = bothends[0]
      edx,edy = bothends[1]
      #両端座標のうち子側の接続座標はどっちだ？
      kolist = get_sozokulist('aid',toaid)
      #子のBoxの座標取得
      kocoords = canvas.coords(kolist[0].kuid)
      if roworclm == 'row':
        #Box左上のｙ座標が基準ライン以上なら挿入・削除により移動している
        #子供側はBoxの上辺で接続するから
        if kocoords[1] >= rc_coord:
          #移動前のy座標
          if insordel=='ins':
            kobef = kocoords[1] - ysize - yspace
          else: #del
            kobef = kocoords[1] + ysize + yspace
        else:
          #移動してない場合
          kobef = kocoords[1]
      else:  #'column'
        #列挿入でBoxのy座標は変化しないから
        kobef = kocoords[1]
      #子のY座標に一致しなかった方が婚姻ラインと接続した方
      stcoords = [stx,sty] if kobef == edy else [edx,edy]
      #--------------------------------------------------------↑
      if roworclm == 'row':
        if stcoords[1] >= rc_coord:
          if insordel=='ins':
            stcoords[1] += ysize+yspace
          else: #del
            stcoords[1] -= ysize+yspace
      else:  #column
        if stcoords[0] >= rc_coord:
          if insordel=='ins':
            stcoords[0] += xsize+ysize
          else:  #del
            stcoords[0] -= xsize+ysize
      fst = [LineOBJ,fraid,stcoords]
    else:  #接続先は両方共box
      fst = [KukeiOBJ,fraid,canvas.coords(frinsta.kuid)]
    snd = [KukeiOBJ,toaid,canvas.coords(toinsta.kuid)]
    #挿入・削除後のLine座標計算
    newcoords = calclinecoords(linetype,fst,snd)
    
    #fuhuラインの場合、このLineに接続しているLineも検討する必要あり
    if linetype=='fuhu':
      #行挿入・削除：夫婦ラインが再婚ラインであり、かつ、夫婦ラインに移動範囲外で
      #             親子ラインが接続されている場合
      if roworclm == 'row' and len(listcoords)>4:
        #夫婦ラインに接続されたラインidのリスト
        lids = solist[0].lineids
        for aid in lids:
          caid = sozoku_insta(aid).lineid
          oycoords = canvas.coords(caid)
          ryotan = get_linecoords_both_ends(oycoords)
          #両端のどちらかが移動範囲外か
          if ryotan[0][1]<=rc_coord or ryotan[1][1]<=rc_coord:
            if insordel=='ins':
              #夫婦ラインのY方向移動量分だけ移動させる
              canvas.move(caid,0,newcoords[1]-listcoords[1])
              #undo情報
              kodst = -(newcoords[1]-listcoords[1])
              insrmv_undolist.append([aid,[0,kodst]])
              #重複移動を排除
              partlineexc.append(caid)
            #else: #行削除の場合親子ラインは特別な処理は不要
              
      #列挿入・削除：通常の夫婦ラインに接続された親子ラインがある場合
      #列を挿入・削除することで、夫婦ラインの形状や接続点が変わることがあるため
      elif roworclm == 'column':
        lids = solist[0].lineids
        for aid in lids:
          caid = sozoku_insta(aid).lineid
          #夫婦ラインとの接続座標だけを調整する
          #（他方の終端は後続処理に任せる）
          oycoords = canvas.coords(caid)
          dmylist = []
          for idx in range(0,len(oycoords),2):
            ix,iy = oycoords[idx],oycoords[idx+1]

            if insordel=='ins' and len(listcoords)==4:
              if ((ix >= listcoords[0] and ix <= listcoords[2]) or \
                 (ix >= listcoords[2] and ix <= listcoords[0])) and \
                 iy == listcoords[1]:
                iy = get_ycoord_online(ix,newcoords)

            elif insordel=='del' and len(listcoords)>4:
              if is_on_line([ix,iy],listcoords):
                if ix >= rc_coord:
                  ix2 = ix - (xsize+xspace)
                  iy = get_ycoord_online(ix2,newcoords)
                else:
                  iy = get_ycoord_online(ix,newcoords)

            dmylist.append(ix)
            dmylist.append(iy)
          #調整後の親子ライン描画
          canvas.coords(caid,*dmylist)
          #undo 情報
          insrmv_undolist.append([aid,oycoords])
    #新規座標でLine再描画
    canvas.coords(i,*newcoords)
    #undo情報
    insrmv_undolist.append([solist[0].absid,listcoords])
  return insrmv_undolist

#----------------------------------------------------
#終了処理
def to_destroy():
  if is_modified() and len(sozokulist):
    #保存の確認と保存処理
    ret = messagebox.askquestion("保存確認","変更内容を保存しますか？",
                                 type='yesnocancel')
    if ret == 'yes':
      if not saveas():
        backup_save()
    elif ret == 'cancel':
      return
    else: #No
      backup_save()
    
  root.destroy()
  
#---main-------------------------------------------
#ルート作成
root=Tk()
#ルートwindow非表示
root.withdraw()
#表示用フォント決定
setup_dispfont()
#Boxスタイルの既定値（起動時は初期値）
default_box_styles = box_init_style()
root.title('相続関係図')
#ルートwindow再表示
root.deiconify()
#ディスプレイ解像度取得
screenwidth = root.winfo_screenwidth()
screenheight = root.winfo_screenheight()
#Variable Classはroot作成後に定義しないとエラーになる
mode = StringVar()  #モードメニューの変数
mode.set('Nor')   #Normalに初期化
#モードが変わったらmode_changeをcall 引数は３つ渡される
mode.trace('w',mode_change)
#初期メニューラベル文字列
label_str = 'M)標準モード'
#メニュー（フォントサイズ等も検討必要）
menu_bar = Menu(root)
#Fileメニュー
file_menu = Menu(menu_bar, tearoff=0)
file_menu.add_command(label="新規",command=init_sozoku)
file_menu.add_command(label="開く",command=loadfrom)
file_menu.add_command(label="上書き保存",command=saveover)
file_menu.add_command(label="名前を付けて保存",command=saveas)
file_menu.add_separator()
file_menu.add_command(label="SVG出力",command=svgout)
file_menu.add_command(label="PDF出力",command=pdfout)
file_menu.add_command(label="Inkscapeで開く",command=inkscape)
file_menu.add_separator()
file_menu.add_command(label="分割印刷用PS出力",command=psout)
##if chkres['inkscape']:
##  file_menu.add_command(label="PDF出力",command=pdfout)
##  file_menu.add_command(label="Inkscapeで開く",command=inkscape)
file_menu.add_separator()
file_menu.add_command(label="終了",command=to_destroy)
menu_bar.add_cascade(label="F)ファイル",menu=file_menu,underline=0)
if not chkres['inkscape']:
  file_menu.entryconfigure(file_menu.index("PDF出力"),state=DISABLED)
  file_menu.entryconfigure(file_menu.index("Inkscapeで開く"),state=DISABLED)
if chkres['os'] != 'Linux' or not chkres['inkscape'] or not chkres['poster']:
  file_menu.entryconfigure(file_menu.index("分割印刷用PS出力"),state=DISABLED)
#編集メニュー
edit_menu = Menu(menu_bar, tearoff=0)
edit_menu.add_command(label='元に戻す',command=undo)
edit_menu.add_separator()
edit_menu.add_command(label="全体移動",command=mov_all)
#Boxスタイルサブメニュー
boxstyle_menu = Menu(edit_menu,tearoff=0)
boxstyle_menu.add_command(label='スタイル一括変更',command=box_style_all)
boxstyle_menu.add_command(label='既定値を変更する',
                          command=edit_box_default_style)
#Boxスタイルは既存Boxのスタイルを一括して変更する（初期値は変更しない）
edit_menu.add_cascade(label="Boxスタイル",menu=boxstyle_menu)
#キャンバススクロール範囲の変更---------
edit_menu.add_command(label='シートサイズ',command=scroll_region)
#表示フォント変更-----------------
font_menu = Menu(edit_menu, tearoff=0)
fntlabel = mkfntlabel()
font_menu.add_command(label=fntlabel,command=changedispfont)
edit_menu.add_cascade(label='表示フォンt',menu=font_menu)
menu_bar.add_cascade(label="E)編集",menu=edit_menu,underline=0)
#モードメニュー---------------------
mode_menu = Menu(menu_bar,tearoff=0)
mode_menu.add_radiobutton(label="標準モード",variable=mode,value='Nor')
mode_menu.add_radiobutton(label="Box追加",variable=mode,value='Box')
mode_menu.add_radiobutton(label="Line追加",variable=mode,value='Lin')
mode_menu.add_radiobutton(label="Memo追加",variable=mode,value='Tex')
mode_menu.add_separator()
mode_menu.add_separator()
mode_menu.add_radiobutton(label="削除モード",variable=mode,value='Del')
#モードメニュー（行・列モード）のサブメニュー
mode_rowclm_menu = Menu(mode_menu,tearoff=0)
mode_rowclm_menu.add_radiobutton(label='挿入モード',variable=mode,value='RcIns')
mode_rowclm_menu.add_radiobutton(label='削除モード',variable=mode,value='RcRmv')
mode_menu.insert_cascade(5,label='行・列',menu=mode_rowclm_menu)
menu_bar.add_cascade(label=label_str,menu=mode_menu,underline=0)
#menu_barのbind（undoバッファの状態をメニュー項目に反映するため）
#ヘルプ--------------------------
help_menu = Menu(menu_bar,tearoff=0)
help_menu.add_command(label='バージョン',command=verinfo)
help_menu.add_command(label='実行環境',command=showenv)
menu_bar.add_cascade(label='H)ヘルプ',menu=help_menu,underline=0)
#--------------------------------------
menu_bar.bind('<Button-1>',pre_menu_bar)
#メニューをルートに登録
root.config(menu=menu_bar)

#以下ポップアップメニュー===========================

#popup メニュー(ボックスメニュー)
popup_menu = Menu(root,tearoff=0)
popup_menu.add_command(label="編集",command=popedit)
popup_menu.add_command(label="コピー",command=copytobuffer)
popup_menu.add_command(label="スタイル",command=popstyle)
popup_menu.add_separator()
popup_menu.add_command(label="連動メモ追加",command=addboxmemo)
popup_menu.add_separator()
popup_menu.add_command(label="削除",command=popdelete)
#ボックスのpopupメニューのサブメニュー
popsub_menu = Menu(popup_menu,tearoff=0)
popsub_menu.add_command(label='スタイル付き',
                        command=lambda : paste_on_box(with_style))
popsub_menu.add_command(label='スタイルなし',
                        command=lambda : paste_on_box(no_style))
popsub_menu.add_command(label='スタイルのみ',
                        command=lambda : paste_on_box(only_style))
popup_menu.insert_cascade(2,label='貼り付け',menu=popsub_menu)
#paste_menu（貼り付けで新規BOX作成)
paste_menu = Menu(root,tearoff=0)
paste_sub = Menu(paste_menu,tearoff=0)
paste_sub.add_command(label='スタイル付き',
                      command=lambda : pastefrombuf(with_style))
paste_sub.add_command(label='スタイルなし',
                      command=lambda : pastefrombuf(no_style))
paste_sub.add_command(label='スタイルのみ',
                      command=lambda : pastefrombuf(only_style))
paste_menu.add_cascade(label="貼り付け",menu=paste_sub)
#メモのポップアップ
memo_pop_menu=Menu(root,tearoff=0)
memo_pop_menu.add_command(label='編集',command=memoedit)
memo_pop_menu.add_command(label='スタイル',command=memosize)
memo_pop_menu.add_separator()
memo_pop_menu.add_command(label='連動メモに変更',command=chgboxmemo)
memo_pop_menu.add_separator()
memo_pop_menu.add_command(label='削除',command=memodelete)
#連動メモメニューのインデックス
memopop_iboxmemo = memo_pop_menu.index('連動メモに変更')

#ラインのポップアップメニュー
line_pop_menu=Menu(root,tearoff=0)
line_pop_menu.add_command(label='スタイル',command=linestyle)
line_pop_menu.add_separator()
line_pop_menu.add_command(label='削除',command=linedelete)
#１行挿入、削除のポップアップ
onerow_pop_menu=Menu(root,tearoff=0)
onerow_pop_menu.add_command(label='１行挿入',
                            command=lambda : onercins('row'))
onerow_pop_menu.add_separator()
onerow_pop_menu.add_command(label='１行削除',
                            command=lambda : onercrmv('row'))
#１列挿入、削除のポップアップ
onecolumn_pop_menu=Menu(root,tearoff=0)
onecolumn_pop_menu.add_command(label='１列挿入',
                               command=lambda : onercins('column'))
onecolumn_pop_menu.add_separator()
onecolumn_pop_menu.add_command(label='１列削除',
                               command=lambda : onercrmv('column'))

#フレーム上にキャンバスとスクロールバーを配置
#フレーム作成
frame = Frame(root, bd=2, relief=SUNKEN)
frame.grid_rowconfigure(0, weight=1)
frame.grid_columnconfigure(0, weight=1)
#フレーム上にスクロールバー作成
xscrollbar = Scrollbar(frame, orient=HORIZONTAL)
xscrollbar.grid(row=1, column=0, sticky=E+W)
yscrollbar = Scrollbar(frame, orient=VERTICAL)
yscrollbar.grid(row=0, column=1, sticky=N+S)
#フレーム上にキャンバス作成
canvas = Canvas(frame, width=screenwidth-100,
                height=screenheight-100,
                bd=0, scrollregion=(0, 0, xmax, ymax),
                xscrollcommand=xscrollbar.set,
                yscrollcommand=yscrollbar.set)
canvas.grid(row=0, column=0, sticky=N+S+E+W)
xscrollbar.config(command=canvas.xview)
yscrollbar.config(command=canvas.yview)
frame.pack(expand=1,fill=BOTH)
#グリッドライン
gridlines()
#キーイベント
#ライン追加の際、<Escape>で選択中止
root.bind('<Escape>',key_ev)
#右クリック処理（貼り付けメニュー）
if cursys == 'Darwin':  #macOS
  canvas.bind('<ButtonRelease-2>',canbtn3,'+')
else:
  canvas.bind('<ButtonRelease-3>',canbtn3,'+')
##canvasのドラッグ移動は見送り。ホイール動作で対応
##canvas.bind('<Button-1>',cvpressed,'+')
##canvas.bind('<Button1-Motion>',cvdragging,'+')
#canvasをマウスホイールで上下スクロールさせるためのバインド
#windows,MacOS版は<Button-4,5>ではなく<MouseWheel>を使う
#ただし、MacOSのchkres['os']の値が不明なのでMac未対応
if chkres['os'] == 'Linux':
  #canvas 上下スクロール
  canvas.bind('<Button-4>',lambda event :canvas.yview('scroll',-1,'units'))
  canvas.bind('<Button-5>',lambda event :canvas.yview('scroll',1,'units'))
  #canvas 左右スクロール
  canvas.bind('<Shift-Button-4>',lambda event :canvas.xview('scroll',-1,'units'))
  canvas.bind('<Shift-Button-5>',lambda event :canvas.xview('scroll',1,'units'))
elif chkres['os'] == 'Windows':
  canvas.bind('<MouseWheel>',
              lambda event :canvas.yview('scroll',int(event.delta/120),'units'))
  canvas.bind('<Shift-MouseWheel>',
              lambda event :canvas.xview('scroll',int(event.delta/120),'units'))
elif chkres['os'] == 'Darwin':  #macOS
  canvas.bind('<MouseWheel>',
              lambda event :canvas.yview('scroll',int(event.delta),'units'))
  canvas.bind('<Shift-MouseWheel>',
              lambda event :canvas.xview('scroll',int(event.delta),'units'))
  
#終了時処理
root.protocol("WM_DELETE_WINDOW",to_destroy)
#イベントループ
root.mainloop()
#メニューでdesrtoyをコール。
#root.destroy()
