#
# -*- coding: utf-8 -*-
#
#-------------------------------------
## sozoku_init.dic（pickle）関係の処理
#-------------------------------------
import pickle as pi
import os.path


#---------------------------------------------
#sozoku_init.dicからロードして結果（辞書）を返す
#sozoku_init.dicが存在しない場合は空の辞書を返す
#---------------------------------------------
def sozokudic_load(fdic):
  if not os.path.exists(fdic):
    return {}
  try:
    with open(fdic,'rb') as fp:
      load_dic = pi.load(fp)
  except (pi.UnpicklingError,OSError):
    messagebox.showerror('ロードエラー',"sozoku_init.dicからロードできません")
    return {}
  return load_dic

#---------------------------------------------
#与えられた変数（辞書）をsozoku_init.dic に書き出す
#---------------------------------------------
def sozokudic_save(mdic,fdic):
  try:
    with open(fdic,'wb') as fp:
      pi.dump(mdic,fp,2)
  except (pi.PicklingError,OSError):
    messagebox.showerror('セーブエラー',"sozoku_init.dicへ書き出しできません")

#---------------------------------------------
# 直接実行
#---------------------------------------------
if __name__=='__main__':
  #sozokuスクリプトがあるフォルダ内のファイル
  fdic = './sozoku_init.dic'
  dic = sozokudic_load(fdic)
  if not len(dic):
    print('<'+fdic+'>からロードできません。')
  else:
    print(dic)
