#
# -*- coding: utf-8 -*-
#
# set_dispfont.py

from tkinter.messagebox import *
import sozoku_init as soi
import select_font as sef
#-----------------------------------
#起動時の表示フォント設定
#表示用フォント及び設定辞書を返す
#-----------------------------------
def startup_dispfontset(parent,fdic,deffontname,keyname):
  #初期設定ファイル読み込み
  tmpdic =soi.sozokudic_load(fdic)
  if len(tmpdic):
    #初期設定辞書の中に表示用フォントのキーがあるか
    if keyname in tmpdic:
      tmpdispfontname = tmpdic[keyname]
      #表示用フォントがシステムに存在するか
      if sef.is_font_insystem(tmpdispfontname):
        return [tmpdispfontname,'init',tmpdic]
  #デフォルトはIPA明朝
  if sef.is_font_insystem(deffontname):
    return [deffontname,'default',tmpdic]
  #代替フォントの選択
  sef.fontlist = sef.get_font_list()
  #insta = sef.FontSelect_dialog(parent,'フォント名選択ダイアログ')
  result = sef.select_font(parent)
  if len(result):
    return [result,'choice',tmpdic]
  else:
    #代替フォント選択がない場合、表示フォントはひとまず既定フォントとする
    return [deffontname,'cancel',tmpdic]

#----------------------------------------
#初期フォント（代替フォント）として登録するかどうか
#----------------------------------------
def regist_font(fontname,sozokudic,keyname,fdic):
  if askyesno('初期フォント',fontname+'を初期フォントとして登録しますか？'):
    #print('yes')
    sozokudic[keyname] = fontname
    soi.sozokudic_save(sozokudic,fdic)
    if __name__=='__main__':
      print(fontname+'を初期フォントとして登録しました')
    else:
      showinfo('初期フォント',fontname+'を初期フォントとして登録しました')

#-------------------------------------------
# メニューからの表示フォント選択
#-------------------------------------------
def menu_dispfontset(parent,sozokudic,fdic,keyname):
  #フォント一覧からフォント選択
  sef.fontlist = sef.get_font_list()
  selfont = sef.select_font(parent)
  #選択なければ戻る
  if not len(selfont):
    return selfont
  #選択あれば初期フォントにするかどうか
  regist_font(selfont,sozokudic,keyname,fdic)
  return selfont
#--------------------------------
#テスト
#--------------------------------
if __name__=='__main__':
  sozokudic = {}
  fdic = './sozoku_init.dic'
  deffontname = 'IPA明朝'
  keyname = 'subfontname'
  from tkinter import *
  root = Tk()
  root.withdraw()
  selfont = startup_dispfontset(root,fdic,deffontname,keyname)
  if selfont[1]=='init':
    print(selfont[0]+'：初期フォントを読み込みました')
  elif selfont[1]=='default':
    print(selfont[0]+'：既定フォントを表示フォントに設定しました')
  elif selfont[1]=='choice':
    print(selfont[0]+'が表示フォントに選択されました')
    regist_font(selfont[0],sozokudic,keyname,fdic)
  elif selfont[1]=='cancel':
    print(selfont[0]+'を表示フォントに設定しました')
  root.destroy()
  
